% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{simBac}
\alias{simBac}
\alias{simBac,Bac-method}
\title{Function for one simulation iteration for objects of Bac class}
\usage{
simBac(object, arena, j, sublb, bacnum)

\S4method{simBac}{Bac}(object, arena, j, sublb, bacnum)
}
\arguments{
\item{object}{An object of class Bac.}

\item{arena}{An object of class Arena defining the environment.}

\item{j}{The number of the iteration of interest.}

\item{sublb}{A vector containing the substance concentrations in the current position of the individual of interest.}

\item{bacnum}{integer indicating the number of bacteria individuals per gridcell}
}
\value{
Returns the updated enivironment of the \code{population} parameter with all new positions of individuals on the grid and all new substrate concentrations.
}
\description{
The generic function \code{simBac} implements all neccessary functions for the individuals to update the complete environment.
}
\details{
Bacterial individuals undergo step by step the following procedures: First the individuals are constrained with \code{constrain} to the substrate environment, then flux balance analysis is computed with \code{optimizeLP}, after this the substrate concentrations are updated with \code{consume}, then the bacterial growth is implemented with \code{growth}, the potential new phenotypes are added with \code{checkPhen}, finally the additional and conditional functions \code{lysis}, \code{move} or \code{chemotaxis} are performed. Can be used as a wrapper for all important bacterial functions in a function similar to \code{simEnv}.
}
\examples{
NULL
}
\seealso{
\code{\link{Bac-class}}, \code{\link{Arena-class}}, \code{\link{simEnv}}, \code{constrain}, \code{optimizeLP}, \code{consume}, \code{growth}, \code{checkPhen}, \code{lysis}, \code{move} and \code{chemotaxis}
}

