% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping.batches.R
\name{map.overlapping.batches}
\alias{map.overlapping.batches}
\title{Mapping overlapping batches}
\usage{
map.overlapping.batches(input.seq, size = 50, overlap = 15,
  fun.order = NULL, phase.cores = 1, ripple.cores = 1, verbosity = NULL,
  max.dist = Inf, ws = 4, increase.every = 4, max.tries = 10,
  min.tries = 0, seeds = NULL, optimize = "likelihood", ...)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{size}{The center size around which an optimum is to be searched}

\item{overlap}{The desired overlap between batches}

\item{fun.order}{A function that is applied to each batch to improve
marker order. See \code{\link[BatchMap]{ripple.ord}}}

\item{phase.cores}{The number of parallel processes to use when estimating
the phase of a marker. (Should be no more than 4)}

\item{ripple.cores}{The number of parallel processes to use when calculating
alternative order.}

\item{verbosity}{A character vector that includes any or all of "batch",
"order", "position", "time" and "phase" to output progress status
information.}

\item{max.dist}{The maximum distance (in cM) two markers can have in a batch
before automatic reordering is triggered (given that \code{fun.order} was
set).}

\item{ws}{The window size that the reordering function should use}

\item{increase.every}{Increase the window size by one every n-th round when
re-ordering.}

\item{max.tries}{The maximum number of re-ordering tries. Failing to order
after max.tries outputs a warning.}

\item{min.tries}{The minimum number of re-ordering tries.}

\item{seeds}{A vector of phase information used as seeds for the first
batch}

\item{optimize}{Either "likelihood" or "count". Passed to \code{ripple.ord}
in order to optimize the map's likelihood or the RECORD COUNT criterion.
Unless you are absolutely sure why, you should use "likelihood".}

\item{...}{Other arguments passed to \code{fun.order}}
}
\value{
A list with the first element \code{Map} being an object of class
\code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{outcross} with the raw
data.} \item{twopt}{name of the object of class \code{rf.2pts} with the
2-point analyses.} Secondly \code{batches}, a list of \code{Map}s for each
of the batches.
}
\description{
Apply the batch mapping algorithm using overlapping windows.
}
\details{
This algorithm implements the overlapping batch maps for high density
marker sets. The mapping problem is reduced to a number of subsets (batches)
which carry information forward in order to more accurately estimate
recombination fractions and phasing. Further the user has the option of
setting \code{fun.order} to a function that tries different orders and
iteratively reorders markers to improve the map. See
\code{\link[BatchMap]{ripple.ord}} for such an implementation. The ordering
function is triggered at least \code{min.tries} times per batch, or as
long as a batch has two markers with a distance greater than
\code{max.dist}.
}
\seealso{
\code{\link[BatchMap]{pick.batch.sizes}}, \code{\link[BatchMap]{map}}
}
\author{
Bastian Schiffthaler, \email{bastian.schiffthaler@umu.se}
}
\keyword{utilities}
