% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_FolderTemplates.R
\name{create_FolderTemplates}
\alias{create_FolderTemplates}
\title{Create Folder Templates}
\usage{
create_FolderTemplates(
  path,
  mode = "SG",
  n_folders = 1,
  names = paste("Sample_", 1:n_folders),
  verbose = TRUE
)
}
\arguments{
\item{path}{\link{character} (\strong{required}): path to the folder where the templates
should be created}

\item{mode}{\link{character} (\emph{with default}): depending on the dataset you can
create templates or single grain (\code{SG}) or multi-grain (\code{MG}) data}

\item{n_folders}{\link{numeric} (\emph{with default}): number of template folders
to be created}

\item{names}{\link{character} (\emph{optional}): allows give own names to the subfolders.}

\item{verbose}{\link{logical} (\emph{with default}): enables/disables verbose mode}
}
\value{
If the templates were created successfully on the hard drive, the function
returns nothing.
}
\description{
Create file and folder structure templates on the user hard drive
as expected by \link{Generate_DataFile} and \link{Generate_DataFile_MG}. Files and data in the
folders must then be overwritten manually with user data. The function intends to
minimise the errors going along with the creation of these folder structures.
The function uses the example data of \code{BayLum} to create the templates.
}
\section{Function version}{
 0.1.0
}

\examples{
create_FolderTemplates(tempdir())


}
\seealso{
\link{Generate_DataFile}, \link{Generate_DataFile_MG}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University
(United Kingdom)
} 

\section{How to cite}{
Kreutzer, S., 2020. create_FolderTemplates(): Create Folder Templates. Function version 0.1.0. In: Christophe, C., Philippe, A., Kreutzer, S., Guerin, G., 2020. BayLum: Chronological Bayesian Models Integrating Optically Stimulated. R package version 0.2.0. https://CRAN.r-project.org/package=BayLum
}

\keyword{IO}
\keyword{datagen}
