% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesFluxR.R
\name{BNN}
\alias{BNN}
\title{Create a Bayesian Neural Network}
\usage{
BNN(x, y, like, prior, init)
}
\arguments{
\item{x}{For a Feedforward structure, this must be a matrix of dimensions
variables x observations; For a recurrent structure, this must be a
tensor of dimensions sequence_length x number_variables x number_sequences;
In general, the last dimension is always the dimension over which will be batched.}

\item{y}{A vector or matrix with observations.}

\item{like}{Likelihood; See for example \code{\link{likelihood.feedforward_normal}}}

\item{prior}{Prior; See for example \code{\link{prior.gaussian}}}

\item{init}{Initialiser; See for example \code{\link{initialise.allsame}}}
}
\value{
List with the following content
\itemize{
    \item `juliavar` - the julia variable containing the BNN
    \item `juliacode` - the string representation of the BNN
    \item `x` - x
    \item `juliax` - julia variable holding x
    \item `y` - y
    \item `juliay` - julia variable holding y
}
}
\description{
Create a Bayesian Neural Network
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sampler <- sampler.SGLD()
  ch <- mcmc(bnn, 10, 1000, sampler)
}


}
