% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{bayesgmed_summary}
\alias{bayesgmed_summary}
\title{Print a summary of the estimated causal mediation model}
\usage{
bayesgmed_summary(
  model = NULL,
  level = 0.95,
  pars = c("NDE_control", "NDE_treated", "NIE_control", "NIE_treated", "ANDE", "ANIE",
    "TE"),
  digits = 3
)
}
\arguments{
\item{model}{A \code{stanfit} object obtained from \code{bayesgmed()}.}

\item{level}{The "confidence" level that defines the limits of the credible intervals (default is .95, i.e. 95\% CIs).}

\item{pars}{The parameters to summarize (defaults to main causal effect estimands similar to the \code{mediation} package; see Details).}

\item{digits}{The number of decimal points to display in the output (default is 3).}
}
\value{
A \code{data.frame} summarizing the estimated causal mediation model, including the following columns:
\itemize{
\item \code{Parameter}: the name of the parameter.
\item \code{Mean}: the mean of the parameter's posterior distribution.
\item \code{Median}: the median of the parameter's posterior distribution.
\item \code{SE}: the standard deviation of the parameter's posterior distribution.
\item \code{ci_lwr}: the lower limit of the credible interval.
\item \code{ci_upr}: the upper limit of the credible interval.
\item \code{n_eff}: the number of efficient samples.
\item \code{Rhat}: a value of 1.00 suggests model convergence.
}
}
\description{
Print a summary of the estimated causal mediation model
}
\details{
After estimating a model with \code{bayesgmed()}, use \code{bayesgmed_summary(fit)} to display the estimated results,
where \code{fit} is an object containing the fitted model. By default, \code{bayesgmed_summary()} only displays a subset of
the estimated parameters:
- \code{NDE_control}: direct effect estimate when the exposure level is set to the control value.
- \code{NDE_treated}: direct effect estimate when the exposure level is set to the treated value.
- \code{NIE_control}: mediated effect estimate when the exposure level is set to the control value.
- \code{NIE_treated}: mediated effect estimate when the exposure level is set to the treated value.
- \code{ANDE}: average direct effect of X on Y.
- \code{ANIE}: average indirect effect of X on Y.
- \code{TE}: the total effect of A on Y.
To display all estimated parameters where all chains merged, set \code{pars = NULL}. This will print all parameters defined
in the model definitions, including the most important ones:
- \code{alphaZ[]}: parameter estimate of the confounders (i.e., X -> Y) relationship, listed in the order they are specified
in the \code{covariates} argument of \code{bayesgmed()}. \code{alpha[1]} is the intercept.
- \code{alphaM}: parameter estimate of the M -> Y relationship.
- \code{alphaA}: parameter estimate of the A -> Y relationship.
- \code{betaZ}: parameter estimate of the confounders (i.e., X -> M) relationship, listed in the order they are specified
in the \code{covariates} argument of \code{bayesgmed()}. \code{beta[1]} is the intercept

To learn more about the additional parameters, refer to the Stan code
(\code{cat(get_stancode(fit))}).
}
\author{
Belay B. Yimer \email{belaybirlie.yimer@manchester.ac.uk}
}
