% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmallows}
\alias{rmallows}
\title{Sample from the Mallows distribution.}
\usage{
rmallows(rho0, alpha0, n_samples, burnin, thinning, leap_size = 1L,
  metric = "footrule")
}
\arguments{
\item{rho0}{Vector specifying the latent consensus ranking.}

\item{alpha0}{Scalar specifying the scale parameter.}

\item{n_samples}{Integer specifying the number of random samples to generate.}

\item{burnin}{Integer specifying the number of iterations to discard as burn-in.}

\item{thinning}{Integer specifying the number of MCMC iterations to perform
between each time a random rank vector is sampled.}

\item{leap_size}{Integer specifying the step size of the leap-and-shift proposal distribution.}

\item{metric}{Character string specifying the distance measure to use. Available
options are \code{"footrule"} (default), \code{"spearman"}, \code{"cayley"}, and
\code{"kendall"}. For sampling from the Mallows model with Cayley and Kendall distances
the \code{PerMallows} package \insertCite{irurozki2016}{BayesMallows} can also be used.}
}
\description{
Sample from the Mallows distribution with arbitrary distance metric using
a Metropolis-Hastings algorithm.
}
\references{
\insertAllCited{}
}
\keyword{internal}
