% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burnin.R
\name{burnin}
\alias{burnin}
\alias{burnin.BayesMallows}
\alias{burnin.BayesMallowsMixtures}
\alias{burnin.SMCMallows}
\title{See the burnin}
\usage{
burnin(model, ...)

\method{burnin}{BayesMallows}(model, ...)

\method{burnin}{BayesMallowsMixtures}(model, ...)

\method{burnin}{SMCMallows}(model, ...)
}
\arguments{
\item{model}{A model object.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
An integer specifying the burnin, if it exists. Otherwise \code{NULL}.
}
\description{
See the current burnin value of the model.
}
\examples{
set.seed(445)
mod <- compute_mallows(setup_rank_data(potato_visual))
assess_convergence(mod)
burnin(mod)
burnin(mod) <- 1500
burnin(mod)
plot(mod)
#'
models <- compute_mallows_mixtures(
  data = setup_rank_data(cluster_data),
  n_clusters = 1:3)
burnin(models)
burnin(models) <- 100
burnin(models)
burnin(models) <- c(100, 300, 200)
burnin(models)
}
\seealso{
Other modeling: 
\code{\link{burnin<-}()},
\code{\link{compute_mallows}()},
\code{\link{compute_mallows_mixtures}()},
\code{\link{compute_mallows_sequentially}()},
\code{\link{sample_prior}()},
\code{\link{update_mallows}()}
}
\concept{modeling}
