% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_blc.R
\name{quantile.BLC}
\alias{quantile.BLC}
\title{Sample Quantiles for BLC fitted models}
\usage{
\method{quantile}{BLC}(x, q, name, ...)
}
\arguments{
\item{x}{A \code{BLC} object, result of a call to blc() function.}

\item{q}{A real number that represents the probability of the quantiles.}

\item{name}{A character with a parameter name of the blc model that should be returned. It can be one of these: "alpha", "beta", "kappa", "phiv", "theta", "phiw".}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data.frame with the quantiles of the selected parameter.
}
\description{
Compute the quantiles based on the resulting chains from a fitted BLC model.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, numit = 100, warmup = 20)

## Parameters' median and quantiles 0.05, 0.95
quantile(fit, c(0.05, 0.5, 0.95), "alpha")
quantile(fit, c(0.05, 0.5, 0.95), "beta")
quantile(fit, c(0.05, 0.5, 0.95), "kappa")
quantile(fit, c(0.05, 0.5, 0.95), "phiv") ## random error precision
quantile(fit, c(0.05, 0.5, 0.95), "theta") ## drift parameter
quantile(fit, c(0.05, 0.5, 0.95), "phiw")

}
\seealso{
\code{\link[=quantile.PredBLC]{quantile.PredBLC()}} for \code{PredBLC} method.
}
