% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_dlm.R
\name{fitted.DLM}
\alias{fitted.DLM}
\title{DLM: Fitted death probabilities (qx)}
\usage{
\method{fitted}{DLM}(object, age = NULL, prob = 0.95, ...)
}
\arguments{
\item{object}{Object of the following classes: \code{DLM} or \code{ClosedDLM}.}

\item{age}{Vector with the ages to calculate the death probabilities (Optional). By default, all ages are considered.}

\item{prob}{Coverage probability of the predictive intervals.}

\item{...}{Other arguments.}
}
\value{
A data.frame object with the selected ages and the corresponding estimates and predictive intervals of the death probabilities.
}
\description{
This function computes the point estimations of the death probabilities (qx) of a
mortality graduation returned by dlm() or dlm_close() functions.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the log mortality rate of the year 2000, ranging from 0 to 100 years old:
USA2000 = USA[USA$Year == 2000,]
x = 0:100
Ex = USA2000$Ex.Total[x+1]
Dx = USA2000$Dx.Total[x+1]
y = log(Dx/Ex)

## Fitting dlm
fit = dlm(y, M = 100, bn = 20, thin = 1)

## Estimating the death probabilities (qx)
fitted(fit)

}
\seealso{
\code{\link[=fitted.HP]{fitted.HP()}} and \code{\link[=fitted.BLC]{fitted.BLC()}} for \code{HP} or \code{BLC} methods.
}
