% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes_Ord_Design_NPO.R
\name{ss_npo}
\alias{ss_npo}
\title{Determine the sample size for Bayesian two-stage trial design
of ordinal endpoints without proportional odds assumption}
\usage{
ss_npo(nmax, or_alt, pro_ctr, U, alpha, power, ntrial, method)
}
\arguments{
\item{nmax}{the maximum sample size for searching to get the desirable power}

\item{or_alt}{effect size to be detected (under H_1) in
terms of odds ratio}

\item{pro_ctr}{distribution of clinical categories for the
control group}

\item{U}{the desirability of each outcome level}

\item{alpha}{the desirable type I error rate to be controlled}

\item{power}{the desirable power to be achieved}

\item{ntrial}{the number of simulated trials}

\item{method}{whether the statistical test for interim/final analysis is Bayesian or
Frequentist. method = "Frequentist" for Frequentist approach; method = "Bayesian"
for Bayesian approach}
}
\value{
ss_npo() returns recommended sample size for each
of two groups for the interim and final stages, by assuming 1:1
equal randomization for the two groups at each stage; and corresponding power.
}
\description{
Obtain estimated sample size based on user-specified type I
error, power and effect size defined by the odds ratio between
the treatment and control groups, without the proportional
odds (PO) assumption.
}
\details{
Grid search of sample size is used for guarantee a desirable type I error rate.
  The upper limitation is 200, and lower limitation default is sample size 50
  for the control and treatment groups at each stage. Default increment of the
  sequence is 50.

  For the parameter estimation section, we have two options, and can be selected using
  the method argument.Two following options are available: (i) method = "Frequentist",
  (ii) method = "Bayesian". If method = "Frequentist", parameters are estimated via package
  ordinal, which is based on frequentist method, while method = "Bayesian", parameters are
  estimated through Bayesian model.

  Specifically, the numerical utilities U reflect the desirability of each outcome
  level. To do this, in our example, we first set U[1] = 100 and U[5] = 0, and then
  asked physicians to specify numerical values for the intermediate levels, that
  reflect their desirability relative to the best and worst levels.

  Please note, in our example, argument ntrial =  5 is for the time saving purpose.
}
\examples{
set.seed(123)
ss_npo(nmax = 200, or_alt = c(1.6,1.5,1.5,1.4,1.4),
       pro_ctr = c(0.58,0.05,0.17,0.03,0.04,0.13), U = c(100,80,65,25,10,0),
       alpha = 0.05, power = 0.8, ntrial = 5, method = "Frequentist")
}
