% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoke_meta-data.R
\docType{data}
\name{smoke_meta}
\alias{smoke_meta}
\title{Meta-analysis data on self-reported smoking diagnosis accuracy}
\format{An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 51 rows and 10 columns.}
\source{
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC1614767/}
}
\usage{
data(smoke_meta)
}
\description{
Records the true positive, true negative, false positive and false negative
of each diagnosis accuracy study. Also includes the type of questionnaire for reporting
(self (SAQ) or interviewer-administered (IAQ)), and the type of diagnosis (by carbon monoxide (CO) /
carboxyhemoglobin (COHb) /thiocyanate (SCN) /cotinine (COT)). And the type of subjects (
G = general population; S = students), and design of the study (O = observational; I = 
intervention).
}
\examples{
data(smoke_meta)
}
\references{
Patrick, D L et al. Patrick, D L et al. “The validity of self-reported smoking: a review and meta-analysis”. American journal of public health vol. 84,7 (1994): 1086-93.
(\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC1614767/}{PMC})
}
\keyword{dataset}
