% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-fit.R
\name{JAGS_fit}
\alias{JAGS_fit}
\title{Fits a 'JAGS' model}
\usage{
JAGS_fit(
  model_syntax,
  data,
  prior_list,
  chains = 4,
  adapt = 500,
  burnin = 1000,
  sample = 4000,
  thin = 1,
  autofit = FALSE,
  autofit_control = list(max_Rhat = 1.05, min_ESS = 500, max_error = 0.01, max_SD_error
    = 0.05, max_time = list(time = 60, unit = "mins"), sample_extend = 1000),
  parallel = FALSE,
  cores = chains,
  silent = TRUE,
  seed = NULL,
  add_parameters = NULL,
  required_packages = NULL
)
}
\arguments{
\item{model_syntax}{jags syntax for the model part}

\item{data}{data fit the model}

\item{prior_list}{named list of prior distribution
(names correspond to the parameter names)}

\item{chains}{number of chains to be run, defaults to \code{4}}

\item{adapt}{number of samples used for adapting the MCMC chains, defaults to \code{500}}

\item{burnin}{number of burnin iterations of the MCMC chains, defaults to \code{1000}}

\item{sample}{number of sampling iterations of the MCMC chains, defaults to \code{4000}}

\item{thin}{thinning interval for the MCMC samples, defaults to \code{1}}

\item{autofit}{whether the models should be refitted until convergence criteria
specified in \code{autofit_control}. Defaults to \code{FALSE}.}

\item{autofit_control}{a list of arguments controlling the autofit function.
Possible options are:
\describe{
\item{max_Rhat}{maximum R-hat error for the autofit function.
Defaults to \code{1.05}.}
\item{min_ESS}{minimum effective sample size. Defaults to \code{500}.}
\item{max_error}{maximum MCMC error. Defaults to \code{1.01}.}
\item{max_SD_error}{maximum MCMC error as the proportion of standard
deviation of the parameters. Defaults to \code{0.05}.}
\item{max_time}{list specifying the time \code{time} and \code{units}
after which the automatic fitting function is stopped. The units arguments
need to correspond to \code{units} passed to \link[base]{difftime} function.}
\item{sample_extend}{number of samples between each convergence check. Defaults to
\code{1000}.}
}}

\item{parallel}{whether the chains should be run in parallel \code{FALSE}}

\item{cores}{number of cores used for multithreading if \code{parallel = TRUE},
defaults to \code{chains}}

\item{silent}{whether the function should proceed silently, defaults to \code{TRUE}}

\item{seed}{seed for random number generation}

\item{add_parameters}{vector of additional parameter names that should be used
monitored but were not specified in the \code{prior_list}}

\item{required_packages}{character vector specifying list of packages containing
JAGS models required for sampling (in case that the function is run in parallel or in
detached R session). Defaults to \code{NULL}.}
}
\value{
\code{JAGS_fit} returns an object of class 'runjags'.
}
\description{
A wrapper around
\link[runjags]{run.jags}  that simplifies fitting 'JAGS' models
with usage with pre-specified model part of the 'JAGS' syntax, data and list
of prior distributions.
}
\examples{
# simulate data
set.seed(1)
data <- list(
  x = rnorm(10),
  N = 10
)
data$x

# define priors
priors_list <- list(mu = prior("normal", list(0, 1)))

# define likelihood for the data
model_syntax <-
  "model{
    for(i in 1:N){
      x[i] ~ dnorm(mu, 1)
    }
  }"

# fit the models
fit <- JAGS_fit(model_syntax, data, priors_list, seed = 0)

}
\seealso{
\code{\link[=JAGS_check_convergence]{JAGS_check_convergence()}}
}
