% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_activations.R
\name{id_activations.classical}
\alias{id_activations.classical}
\title{Identification of areas of activation in a General Linear Model using classical methods}
\usage{
id_activations.classical(
  model_obj,
  tasks,
  session,
  alpha = 0.05,
  gamma = 0,
  correction = c("FWER", "FDR", "none"),
  mesh = NULL
)
}
\arguments{
\item{model_obj}{A \code{BayesGLM} object}

\item{tasks, session, alpha, gamma}{See \code{\link{id_activations}}.}

\item{correction}{(character) Either 'FWER' or 'FDR'. 'FWER' corresponds to the
family-wise error rate with Bonferroni correction, and 'FDR' refers to the
false discovery rate using Benjamini-Hochberg.}

\item{mesh}{(Optional) An \code{"inla.mesh"} object (see \code{\link{make_mesh}} for
surface data). Only necessary for computing surface areas of identified activations.}
}
\value{
A matrix corresponding to the
0-1 activation status for the model coefficients.
}
\description{
Identification of areas of activation in a General Linear Model using classical methods
}
\keyword{internal}
