% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_to_fit_MRMC.R
\name{metadata_to_fit_MRMC}
\alias{metadata_to_fit_MRMC}
\title{Create metadata for MRMC data}
\usage{
metadata_to_fit_MRMC(dataList)
}
\arguments{
\item{dataList}{An list, should include  the following \R objects:\code{m,q,c,h,f,NL,C,M,Q} which means from the right

\code{m } means the modality ID vector

\code{q } means the reader ID vector

\code{c } means the confidence level

\code{h } means the number of hits

\code{f } means the number of false alarm

\code{NL } means the Total number of lesions for all images

\code{C } means the highest number of confidence level

\code{M } means the number of modalities

\code{Q } means the number of readers.

The detail of these dataset, please see the example datasets, e.g. \code{\link{dd}}.}
}
\value{
A list. A metadata such as number of cumulative false alarms and hits to create and draw the curve.


\describe{

\strong{ The following two are useful:} \emph{ I rediscover it  at 2019 Jun 18}
\item{ \code{ harray}  }{An array of hit, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }

\item{ \code{ farray}   }{An array of false alarms, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }


}
}
\description{
From data of number of hits and false alarms, we calculate the number of cumulative false positives and hits.
Since there are three subscripts, reader, modality, and image, we create array format and vector format etc...
}
\details{
To fit a model to data, we need False Positive Fraction and True Positive Fractions which are cumulative sums over number of lesions.
}
\examples{
\donttest{
#First, we prepare the data endowed with this package.



             dat  <- get(data("dataList.Chakra.Web"))





             metadata_to_fit_MRMC(dat)






#Now, we get  meta-data.


# Revised 2019 Jun 18

}# dottest

}
