% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_print.R
\name{print}
\alias{print}
\title{A method for a generic function \code{print()} for class "\code{\link{stanfitExtended}}"}
\arguments{
\item{x}{An S4 object of  class \code{\link{stanfitExtended}} inherited  from the class stanfit in the rstan package.}
}
\description{
This is a method for print and \code{\link{stanfitExtended}} S4 class.
}
\examples{
 \donttest{
# How to use a new method for generic function "print".
#=============================The First Example======================================


#(1)First, we prepare the example data from this package.



                      dat  <- BayesianFROC::dataList.Chakra.1



# The R object named dat is a list which contains the hits and false alarms representing
# an FROC dataset. To confirm it, the function viewdata() can be used;



                              viewdata(dat)




#(2)Second, we run fit_Bayesian_FROC() in which the rstan::sampling() is implemented.
#Fit to data named "dat"   the author's Bayesian model by



                         fit <-  fit_Bayesian_FROC(dat)




#(3)Thirdly, we obtain the R object fit of  S4 class
# named stanfitExtended that is an inherited class from the  S4 class stanfit
# defined in the package rstan.
# For the S4 class stanfitExtended defined in this package, we can use
# the generic function print for this new S4 class.



                               print(fit)



# To use the generic functin print() as a  object of class "stanfit",
#  we coerce class of fit into stanfit from stanfitExtended as follows;




                            fitt <- methods::as(fit,"stanfit")




# THe R object "fitt" is a fitted model object of class stanfit,
# thus we can also apply the generic function print() as follows:



                               print(fitt)



#=============================The Second Example======================================


#(1)First, we prepare the example data from this package.

                      dat  <- BayesianFROC::dataList.Chakra.Web


#(2)Second, we run fit_Bayesian_FROC() in which the rstan::sampling() is implemented.
#Fit to data named "dat"   the author's Bayesian model by


                        fit <-  fit_Bayesian_FROC(dat)

#(3)Thirdly, we obtain the R object fit of  S4 class
# named stanfitExtended that is an inherited class from the  S4 class stanfit
# defined in the package rstan.
# For the S4 class stanfitExtended defined in this package, we can use
# the generic function print for this new S4 class.



                            print(fit)





# 2019.05.21 Revised.


}# dottest



}
