% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawCurves.R
\name{DrawCurves_MRMC_pairwise_BlackWhite}
\alias{DrawCurves_MRMC_pairwise_BlackWhite}
\title{Draw the FROC  curves without colour}
\usage{
DrawCurves_MRMC_pairwise_BlackWhite(StanS4class, modalityID, readerID,
  new.imaging.device = TRUE, DrawFROCcurve = TRUE,
  DrawAFROCcurve = FALSE, DrawCFPCTP = TRUE,
  Draw.Flexible.upper_y = TRUE, Draw.Flexible.lower_y = TRUE,
  summary = TRUE, type = 1)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}  that can be passed to the \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{modalityID}{This is a vector indicating modalityID whose component is natural namber.}

\item{readerID}{This is a vector indicating readerID whose component is natural namber.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFPCTP points are  to be drawn.}

\item{Draw.Flexible.upper_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the upper bounds of vertical axis are determined automatically.}

\item{Draw.Flexible.lower_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the lower bounds of vertical axis are determined automatically.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{type}{An integer, for the color of background and etc.}
}
\description{
Plot curves without any color (dark theme), that is, black and white (white backgroud with black curves).  Draw  FROC  curves and  AFROC curves for user's specified modality and user's specified reader.
Using this function \strong{repeatedly}, we can draw or compare the different reader and modality in a  \strong{same} plane simultaneously.
So, we can visualize the difference of modality (reader).
}
