% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfirmConvergence.R
\name{ConfirmConvergence}
\alias{ConfirmConvergence}
\title{Check R hat criterion}
\usage{
ConfirmConvergence(StanS4class, summary = TRUE, digits = 2)
}
\arguments{
\item{StanS4class}{An S4 object of the class \strong{\emph{\code{\link[rstan]{stanfit}}}}. No need that it is the S4 class \strong{\code{ \link{stanfitExtended}}}.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{digits}{A positive integer, indicating digits for R hat statistics.}
}
\value{
Logical: \code{TRUE} of \code{FALSE}. If model converges ( all R hat are closed to 1) then it is \code{TRUE}, and if not( some R hat is far from 1), then  \code{FALSE}.
}
\description{
Calculates the maximum and the minimal values of R hat over all parameters.
 In addition, it returns a loginal \R object whether R hat is good (\code{TRUE}) or bad (\code{FALSE}).
}
\details{
Evaluates convergence criterion based on only the R hat statistics for a fitted model object. Revised Nov 23.
}
\examples{
\donttest{
#================The first example======================================

            #((Primitive way)).
#1) Build the data for a singler reader and a single modality  case.

dat <- list(c=c(3,2,1),    #Confidence level
            h=c(97,32,31), #Number of hits for each confidence level
            f=c(1,14,74),  #Number of false alarms for each confidence level

            NL=259,       #Number of lesions
            NI=57,        #Number of images
            C=3)          #Number of confidence level

# where, c denotes Confidence level,
#        h denotes number of Hits for each confidence level,
#        f denotes number of False alarms for each confidence level,
#        NL denotes Number of Lesions,
#        NI denotes Number of Images,









#2) Fit the FROC model.
  #Since the above dataset  "dat" are single reader and single modality,
  #the following function fit the non hierarchical model.

          fit <-   BayesianFROC::fit_Bayesian_FROC(dat,ite=1111)



#  Where, the variable "ite" is the iteration of MCMC sampling.
#  Larger iteration is better.



#3.1) Confirm whether our estimates converge.




          ConfirmConvergence(fit)



# By the above R script,
# the diagnosis of convergence will be printed in the R (R-studio) console.
# Which diagnosis is based on only the R hat statistic.
# So someone might consider it is not sufficient, and use the
# Simulation based cariblation (SBC) or other things to diagnosis of the
# convergence or bias.
# Now, I try to implement SBC and it almost be made, but the randomized is not
# sufficient caused seed, so, I have to say it is under construction.
# I am tired,...




# It also return the logical vector indicating whether or not the MCMC converge,
# if MCMC converges, then the return value is TRUE and if not, then FALSE.

# This logical return value is used in this package development
# and the user should not be interested.

# The following was useful for programming.
#3.2) The return value is TRUE or FALSE.

     x <- ConfirmConvergence(fit)

#3.3) If you do not want to print the results, then

      x <- ConfirmConvergence(fit,summary=FALSE)



# 2019.05.21 Revised.
# 2019.12.02 Revised.


}# donttest
}
\references{
Gelman A. &  Rubin, D.B. (1992). Inference from Iterative Simulation Using Multiple Sequences, Statistical Science, Volume 7, Number 4, 457-472.
}
\seealso{
\code{check_rhat()}, which is made by Betanalpha.
}
