% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoronaVirus_Disease_2019.R
\name{CoronaVirus_Disease_2019_prevalence}
\alias{CoronaVirus_Disease_2019_prevalence}
\title{Who should be inspected?}
\usage{
CoronaVirus_Disease_2019_prevalence(pre, se, sp)
}
\arguments{
\item{pre}{Prevalence of population


\deqn{Prob(Truth = diseased | Diagnosis = Positive) = \frac{Se\times pre}{Se \times pre + (1-pre)\times(1-sp)}   }}

\item{se}{Sensitivity of a diagnostic test}

\item{sp}{Specificity of a diagnostic test}
}
\value{
same as \code{ \link{CoronaVirus_Disease_2019}()}
}
\description{
Even if we test all people, the result is true with very low probabilties.
}
\details{
--------------------------------------------------------------------------
\tabular{llll}{

 Diagnosis \ truth   \tab \strong{ Diseased } \tab \strong{   Non-diseased}  \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
 Positive   \tab   se*n     \tab  \eqn{(N-n)(1-sp)}                 \cr
 Negative   \tab   (1-se)*n \tab  \eqn{(N-n)sp}             \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
        \tab   n \tab  \eqn{N-n}      \cr
 }
-------------------------------------------------------------------------


For example,

  if prevalence is 0.0001,

   population is 10000,

specificity = 0.8,

sensitivity = 0.9,


  then the table is the following.

  We can calculates the probability of the event that
  a one whose diagnosis is positive is really diseased
  is

  \deqn{  \frac{9}{1998 + 9} = 9/(1998+9) = 0.00448 percent }


--------------------------------------------------------------------------
\tabular{llll}{

 Diagnosis \ truth   \tab \strong{ Diseased } \tab \strong{   Non-diseased}  \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
 Positive   \tab   9     \tab   1998                \cr
 Negative   \tab   1 \tab   7992            \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
        \tab   \eqn{n = 10} \tab  \eqn{N-n=10000-10}      \cr
 }
-------------------------------------------------------------------------
}
\examples{

CoronaVirus_Disease_2019_prevalence(0.0001, 0.9,0.8)
CoronaVirus_Disease_2019_prevalence(0.03,0.9,0.8)
CoronaVirus_Disease_2019_prevalence(0.3,0.9,0.8)



#========================================================================================
#  If Sensitivity and Specificity is larger, then, the probability is also larger
#========================================================================================


x <- stats::runif(100,0,1)
y <- CoronaVirus_Disease_2019_prevalence(0.1,x,x)

dark_theme(4)
plot(x,y)


#========================================================================================
#  If the prevalence is larger, then, the probability is also larger
#========================================================================================



x <- stats::runif(100,0,1)
y <- CoronaVirus_Disease_2019_prevalence(x,0.9,0.9)

dark_theme(4)
plot(x,y)


}
\seealso{
\code{ \link{CoronaVirus_Disease_2019}()}
}
