% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMC.R
\name{smcSampler}
\alias{smcSampler}
\title{SMC sampler}
\usage{
smcSampler(bayesianSetup, initialParticles = 1000, iterations = 10,
  resampling = T, resamplingSteps = 2, proposal = NULL, adaptive = T,
  proposalScale = 0.5)
}
\arguments{
\item{bayesianSetup}{either an object of class bayesianSetup created by \code{\link{createBayesianSetup}} (recommended), or a log target function}

\item{initialParticles}{initial particles - either a draw from the prior, provided as a matrix with the single parameters as columns and each row being one particle (parameter vector), or a numeric value with the number of desired particles. In this case, the sampling option must be provided in the prior of the BayesianSetup.}

\item{iterations}{number of iterations}

\item{resampling}{if new particles should be created at each iteration}

\item{resamplingSteps}{how many resampling (MCMC) steps between the iterations}

\item{proposal}{optional proposal class}

\item{adaptive}{should the covariance of the proposal be adapted during sampling}

\item{proposalScale}{scaling factor for the proposal generation. Can be adapted if there is too much / too little rejection}
}
\description{
Sequential Monte Carlo Sampler
}
\details{
The sampler can be used for rejection sampling as well as for sequential Monte Carlo. For the former case set the iterations to one.
}
\note{
The SMC currently assumes that the initial particle is sampled from the prior. If a better initial estimate of the posterior distribution is available, this the sampler should be modified to include this. Currently, however, this is not included in the code, so the appropriate adjustments have to be done by hand.
}
\examples{
## Example for the use of SMC 
# First we need a bayesianSetup - SMC makes most sense if we can  for demonstration,
# we'll write a function that puts out the number of model calls

MultiNomialNoCor <- generateTestDensityMultiNormal(sigma = "no correlation")

parallelLL <- function(parMatrix){
  print(paste("Calling likelihood with", nrow(parMatrix), "parameter combinations"))
  out = apply(parMatrix, 1, MultiNomialNoCor)
  return(out)
}

bayesianSetup <- createBayesianSetup(likelihood = parallelLL, lower = rep(-10, 3),
                                     upper = rep(10, 3), parallel = "external")

# Defining settings for the sampler
# First we use the sampler for rejection sampling
settings <- list(initialParticles = 1000, iterations = 1, resampling = FALSE)  
   
# Running the sampler
out1 <- runMCMC(bayesianSetup = bayesianSetup, sampler = "SMC", settings = settings)
#plot(out1)


# Now for sequential Monte Carlo
settings <- list(initialParticles = 100, iterations = 5, resamplingSteps = 1)
out2 <- runMCMC(bayesianSetup = bayesianSetup, sampler = "SMC", settings = settings)
#plot(out2)

}
