% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes_singletest_rel.R
\name{strel}
\alias{strel}
\title{calculate single test reliability estimates}
\usage{
strel(x, estimates = c("alpha", "lambda2", "glb", "omega"),
  interval = 0.95, n.iter = 2000, n.burnin = 50, boot.n = 1000,
  omega.freq.method = "cfa", omega.fit = FALSE, n.obs = NULL,
  alpha.int.analytic = FALSE, bayes = TRUE, freq = TRUE,
  para.boot = FALSE, prior.samp = FALSE, item.dropped = FALSE)
}
\arguments{
\item{x}{A dataset or covariance matrix}

\item{estimates}{A character vector containing the estimands, we recommend using lambda4 with only a few items due to the computation time}

\item{interval}{A number specifying the uncertainty interval}

\item{n.iter}{A number for the iterations of the Gibbs Sampler}

\item{n.burnin}{A number for the burnin in the Gibbs Sampler}

\item{boot.n}{A number for the bootstrap samples}

\item{omega.freq.method}{A character string for the method of frequentist omega, either pfa or cfa}

\item{omega.fit}{A logical for calculating the fit of the single factor model}

\item{n.obs}{A number for the sample observations when a covariance matrix is supplied and the factor model is calculated}

\item{alpha.int.analytic}{A logical for calculating the alpha confidence interval analytically}

\item{bayes}{A logical for calculating the Bayesian estimates}

\item{freq}{A logical for calculating the frequentist estimates}

\item{para.boot}{A logical for calculating the parametric bootstrap, the default is the non-parametric}

\item{prior.samp}{A logical for calculating the prior distributions (necessary for plot functions)}

\item{item.dropped}{A logical for calculating the if-item-dropped statistics}
}
\description{
calculate Bayesian and frequentist single test reliability measures.
Reported are Bayesian credible intervals (HDI) and frequentist confidence intervals (non parametric or parametric bootstrap).
The estimates supported are Cronbach alpha, lambda2/4/6, the glb, and Mcdonald omega.
}
\examples{
summary(strel(cavalini, estimates = "lambda2"))
summary(strel(cavalini, estimates = "lambda2", item.dropped = TRUE))


}
\references{
{
  \insertRef{murphy2007}{Bayesrel}
  \insertRef{lee2007}{Bayesrel}
}
}
