/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.datatype.DataType;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;

public abstract class Importer {
    private LineNumberReader reader;
    private BufferedWriter commentWriter = null;
    private int lastChar = 0;
    private int lastDelimiter = 0;
    private boolean hasComments = false;
    private char startComment = (char)65535;
    private char stopComment = (char)65535;
    private char lineComment = (char)65535;
    private char writeComment = (char)65535;
    private char metaComment = (char)65535;
    private String lastMetaComment = null;

    public Importer(Reader reader) {
        this.reader = new LineNumberReader(reader);
        this.commentWriter = null;
    }

    public Importer(Reader reader, Writer writer) {
        this.reader = new LineNumberReader(reader);
        this.commentWriter = writer != null ? new BufferedWriter(writer) : null;
    }

    public void setCommentDelimiters(char c) {
        this.hasComments = true;
        this.lineComment = c;
    }

    public void setCommentDelimiters(char c, char c2) {
        this.hasComments = true;
        this.startComment = c;
        this.stopComment = c2;
    }

    public void setCommentDelimiters(char c, char c2, char c3) {
        this.hasComments = true;
        this.startComment = c;
        this.stopComment = c2;
        this.lineComment = c3;
    }

    public void setCommentDelimiters(char c, char c2, char c3, char c4, char c5) {
        this.hasComments = true;
        this.startComment = c;
        this.stopComment = c2;
        this.lineComment = c3;
        this.writeComment = c4;
        this.metaComment = c5;
    }

    public void setCommentWriter(Writer writer) {
        this.commentWriter = new BufferedWriter(writer);
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public int getLastDelimiter() {
        return this.lastDelimiter;
    }

    public char nextCharacter() throws IOException {
        if (this.lastChar == 0) {
            this.lastChar = this.readCharacter();
        }
        return (char)this.lastChar;
    }

    public char readCharacter() throws IOException {
        this.skipSpace();
        char c = this.read();
        while (this.hasComments && (c == this.startComment || c == this.lineComment)) {
            this.skipComments(c);
            this.skipSpace();
            c = this.read();
        }
        return c;
    }

    public void unreadCharacter(char c) {
        this.lastChar = c;
    }

    public char next() throws IOException {
        if (this.lastChar == 0) {
            this.lastChar = this.read();
        }
        return (char)this.lastChar;
    }

    public char read() throws IOException {
        int n;
        if (this.lastChar == 0) {
            n = this.reader.read();
            if (n <= 0) {
                throw new EOFException();
            }
        } else {
            n = this.lastChar;
            this.lastChar = 0;
        }
        return (char)n;
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.read();
        try {
            while (c != '\n' && c != '\r') {
                if (this.hasComments) {
                    if (c == this.lineComment) {
                        this.skipComments(c);
                        break;
                    }
                    if (c == this.startComment) {
                        this.skipComments(c);
                        c = this.read();
                    }
                }
                stringBuffer.append(c);
                c = this.read();
            }
            if (c == '\r' && this.next() == '\n') {
                this.read();
            }
            this.lastDelimiter = c;
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public void readSequence(StringBuffer stringBuffer, DataType dataType, String string, int n, String string2, String string3, String string4, String string5) throws IOException, ImportException {
        char c = this.read();
        try {
            int n2 = 0;
            while (n2 < n && string.indexOf(c) == -1) {
                if (this.hasComments && (c == this.startComment || c == this.lineComment)) {
                    this.skipComments(c);
                    c = this.read();
                }
                if (!Character.isWhitespace(c)) {
                    char c2 = c;
                    if (string2.indexOf(c) != -1) {
                        c2 = '-';
                    } else if (string3.indexOf(c) != -1) {
                        c2 = '?';
                    } else if (string4.indexOf(c) != -1) {
                        if (string5 == null) {
                            throw new ImportException("Match character in first sequences");
                        }
                        if (n2 >= string5.length()) {
                            throw new ImportException("Match sequences too short");
                        }
                        c2 = string5.charAt(n2);
                    }
                    stringBuffer.append(c2);
                    ++n2;
                }
                c = this.read();
            }
            this.lastDelimiter = c;
            if (Character.isWhitespace((char)this.lastDelimiter) && string.indexOf(c = this.nextCharacter()) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void readSequenceLine(StringBuffer stringBuffer, DataType dataType, String string, String string2, String string3, String string4, String string5) throws IOException, ImportException {
        char c = this.read();
        try {
            int n = 0;
            while (c != '\r' && c != '\n' && string.indexOf(c) == -1) {
                if (this.hasComments) {
                    if (c == this.lineComment) {
                        this.skipComments(c);
                        break;
                    }
                    if (c == this.startComment) {
                        this.skipComments(c);
                        c = this.read();
                    }
                }
                if (c != ' ' && c != '\t') {
                    char c2 = c;
                    if (string2.indexOf(c) != -1) {
                        c2 = '-';
                    } else if (string3.indexOf(c) != -1) {
                        c2 = '?';
                    } else if (string4.indexOf(c) != -1) {
                        if (string5 == null) {
                            throw new ImportException("Match character in first sequences");
                        }
                        if (n >= string5.length()) {
                            throw new ImportException("Match sequences too short");
                        }
                        c2 = string5.charAt(n);
                    }
                    stringBuffer.append(c2);
                    ++n;
                }
                c = this.read();
            }
            if (c == '\r' && this.next() == '\n') {
                this.read();
            }
            this.lastDelimiter = c;
            if (Character.isWhitespace((char)this.lastDelimiter) && string.indexOf(c = this.nextCharacter()) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public int readInteger() throws IOException, ImportException {
        String string = this.readToken();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public int readInteger(String string) throws IOException, ImportException {
        String string2 = this.readToken(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public double readDouble() throws IOException, ImportException {
        String string = this.readToken();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public double readDouble(String string) throws IOException, ImportException {
        String string2 = this.readToken(string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public String readToken() throws IOException {
        return this.readToken("");
    }

    public String readToken(String string) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        this.nextCharacter();
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            n = this.read();
            try {
                boolean bl4 = Character.isWhitespace((char)n);
                if (bl3 && n == n3) {
                    char c = this.read();
                    if (n == c) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    this.lastDelimiter = 32;
                    this.unreadCharacter(c);
                    bl = true;
                    bl3 = false;
                    continue;
                }
                if (bl2 && (n == 39 || n == 34)) {
                    bl3 = true;
                    n3 = n;
                    bl2 = false;
                    n2 = 0;
                    continue;
                }
                if (n == this.startComment || n == this.lineComment) {
                    this.skipComments((char)n);
                    this.lastDelimiter = 32;
                    bl = true;
                    continue;
                }
                if (bl3) {
                    if (bl4) {
                        ++n2;
                        n = 32;
                    } else {
                        n2 = 0;
                    }
                    if (n2 >= 2) continue;
                    stringBuffer.append((char)n);
                    continue;
                }
                if (bl4) {
                    this.lastDelimiter = 32;
                    bl = true;
                    continue;
                }
                if (string.indexOf(n) != -1) {
                    bl = true;
                    this.lastDelimiter = n;
                    continue;
                }
                stringBuffer.append((char)n);
                bl2 = false;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
        if (Character.isWhitespace((char)this.lastDelimiter)) {
            n = this.nextCharacter();
            while (Character.isWhitespace((char)n)) {
                this.read();
                n = this.nextCharacter();
            }
            if (string.indexOf(n) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        return stringBuffer.toString();
    }

    protected void skipComments(char c) throws IOException {
        int n = 1;
        boolean bl = false;
        StringBuffer stringBuffer = null;
        if (this.nextCharacter() == this.writeComment) {
            this.read();
            bl = true;
        } else if (this.nextCharacter() == this.metaComment) {
            this.read();
            stringBuffer = this.lastMetaComment != null ? new StringBuffer(this.lastMetaComment + ";") : new StringBuffer();
        }
        this.lastMetaComment = null;
        if (c == this.lineComment) {
            String string = this.readLine();
            if (bl && this.commentWriter != null) {
                this.commentWriter.write(string, 0, string.length());
                this.commentWriter.newLine();
            } else if (stringBuffer != null) {
                stringBuffer.append(string);
            }
        } else {
            do {
                char c2;
                if ((c2 = this.read()) == this.startComment) {
                    ++n;
                    continue;
                }
                if (c2 == this.stopComment) {
                    if (bl && this.commentWriter != null) {
                        this.commentWriter.newLine();
                    }
                    --n;
                    continue;
                }
                if (bl && this.commentWriter != null) {
                    this.commentWriter.write(c2);
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(c2);
            } while (n > 0);
        }
        if (stringBuffer != null) {
            this.lastMetaComment = stringBuffer.toString();
        }
    }

    public void skipToEndOfLine() throws IOException {
        char c;
        do {
            c = this.read();
            if (!this.hasComments) continue;
            if (c == this.lineComment) {
                this.skipComments(c);
                break;
            }
            if (c != this.startComment) continue;
            this.skipComments(c);
            c = this.read();
        } while (c != '\n' && c != '\r');
        if (c == '\r' && this.nextCharacter() == '\n') {
            this.read();
        }
    }

    public void skipWhile(String string) throws IOException {
        char c;
        while (string.indexOf(c = this.read()) > -1) {
        }
        this.unreadCharacter(c);
    }

    public void skipSpace() throws IOException {
        this.skipWhile(" \t\r\n");
    }

    public void skipCharacters(String string) throws IOException {
        this.skipWhile(string + " \t\r\n");
    }

    public char skipUntil(String string) throws IOException {
        char c;
        while (string.indexOf(c = this.readCharacter()) == -1) {
        }
        return c;
    }

    public String getLastMetaComment() {
        return this.lastMetaComment;
    }

    public void clearLastMetaComment() {
        this.lastMetaComment = null;
    }

    public static class UnknownTaxonException
    extends ImportException {
        private static final long serialVersionUID = 6611115782536515250L;

        public UnknownTaxonException() {
        }

        public UnknownTaxonException(String string) {
            super(string);
        }
    }

    public static class TooFewTaxaException
    extends ImportException {
        private static final long serialVersionUID = -6349041350075169247L;

        public TooFewTaxaException() {
        }

        public TooFewTaxaException(String string) {
            super(string);
        }
    }

    public static class ShortSequenceException
    extends ImportException {
        private static final long serialVersionUID = 7460033398106047073L;

        public ShortSequenceException() {
        }

        public ShortSequenceException(String string) {
            super(string);
        }
    }

    public static class MissingFieldException
    extends ImportException {
        private static final long serialVersionUID = -7576489210458327552L;

        public MissingFieldException() {
        }

        public MissingFieldException(String string) {
            super(string);
        }
    }

    public static class UnparsableDataException
    extends ImportException {
        private static final long serialVersionUID = 5905130039882401006L;

        public UnparsableDataException() {
        }

        public UnparsableDataException(String string) {
            super(string);
        }
    }

    public static class BadFormatException
    extends ImportException {
        private static final long serialVersionUID = -8206831989674620748L;

        public BadFormatException() {
        }

        public BadFormatException(String string) {
            super(string);
        }
    }

    public static class DuplicateFieldException
    extends ImportException {
        private static final long serialVersionUID = 8047146381348414810L;

        public DuplicateFieldException() {
        }

        public DuplicateFieldException(String string) {
            super(string);
        }
    }

    public static class ImportException
    extends Exception {
        private static final long serialVersionUID = 7858834683324203750L;

        public ImportException() {
        }

        public ImportException(String string) {
            super(string);
        }
    }
}

