/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.io.Importer;
import dr.evolution.io.NexusImporter;
import dr.evolution.tree.FlexibleNode;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class MigrateTreeImporter
extends NexusImporter {
    public static final String POP = "pop";
    public static final String TO_POP = "toPop";
    public static final String FROM_POP = "fromPop";

    public MigrateTreeImporter(Reader reader) {
        super(reader);
    }

    @Override
    public Tree[] importTrees(TaxonList taxonList) throws IOException, Importer.ImportException {
        Tree[] treeArray;
        for (Tree tree : treeArray = super.importTrees(taxonList)) {
            Object object;
            Object object2;
            Object object3;
            NodeRef nodeRef;
            int n;
            for (n = 0; n < tree.getNodeCount(); ++n) {
                nodeRef = tree.getNode(n);
                object3 = tree.getNodeAttribute(nodeRef, TO_POP);
                object2 = tree.getNodeAttribute(nodeRef, POP);
                if (object3 != null && object2 != null && !object3.equals(object2)) {
                    object = nodeRef.getNumber() + "";
                    if (tree.isExternal(nodeRef)) {
                        object = tree.getTaxonId(nodeRef.getNumber());
                    }
                    if (tree.isRoot(nodeRef)) {
                        object = "root";
                    }
                    throw new RuntimeException("toPop = " + object3 + ", " + POP + " = " + object2 + " in node " + (String)object);
                }
                if (object2 != null || object3 == null) continue;
                ((MutableTree)tree).setNodeAttribute(nodeRef, POP, object3);
            }
            for (n = 0; n < tree.getNodeCount(); ++n) {
                nodeRef = tree.getNode(n);
                if (tree.isRoot(nodeRef)) continue;
                object3 = tree.getParent(nodeRef);
                object2 = tree.getNodeAttribute(nodeRef, FROM_POP);
                object = tree.getNodeAttribute((NodeRef)object3, POP);
                if (object2 != null && object != null && !object2.equals(object)) {
                    throw new RuntimeException("fromPop = " + object2 + ", " + POP + " = " + object);
                }
                if (object != null || object2 == null) continue;
                ((MutableTree)tree).setNodeAttribute((NodeRef)object3, POP, object2);
            }
            this.fillInternalGaps(tree, tree.getRoot());
            this.fillExternalGaps(tree);
        }
        return treeArray;
    }

    private void fillExternalGaps(Tree tree) {
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            if (tree.getNodeAttribute(nodeRef, POP) != null) continue;
            ((MutableTree)tree).setNodeAttribute(nodeRef, POP, tree.getNodeAttribute(tree.getParent(nodeRef), POP));
        }
    }

    private Object fillInternalGaps(Tree tree, NodeRef nodeRef) {
        if (!tree.isExternal(nodeRef)) {
            Object object = this.fillInternalGaps(tree, tree.getChild(nodeRef, 0));
            Object object2 = this.fillInternalGaps(tree, tree.getChild(nodeRef, 1));
            if (tree.getNodeAttribute(nodeRef, POP) == null) {
                if (object == null && object2 == null) {
                    throw new RuntimeException("left and right are both null for node " + nodeRef.getNumber());
                }
                if (object == null) {
                    object = object2;
                }
                if (object2 == null) {
                    object2 = object;
                }
                if (object.equals(object2)) {
                    ((MutableTree)tree).setNodeAttribute(nodeRef, POP, object);
                } else {
                    throw new RuntimeException(object + "!=" + object2 + " in children of node " + nodeRef.getNumber());
                }
            }
        }
        return tree.getNodeAttribute(nodeRef, POP);
    }

    @Override
    FlexibleNode readBranch(HashMap<String, Taxon> hashMap) throws IOException, Importer.ImportException {
        String string;
        double d = 0.0;
        this.clearLastMetaComment();
        FlexibleNode flexibleNode = this.nextCharacter() == '(' ? this.readInternalNode(hashMap) : this.readExternalNode(hashMap);
        if (this.getLastDelimiter() != 58 && this.getLastDelimiter() != 44 && this.getLastDelimiter() != 41 && (string = this.readToken(",():;")).length() > 0) {
            flexibleNode.setAttribute("label", string);
        }
        if (this.getLastDelimiter() == 58) {
            d = this.readDouble(" ,():;");
            if (this.getLastMetaComment() != null) {
                this.parseMigrationString(this.getLastMetaComment(), flexibleNode);
                this.clearLastMetaComment();
            }
        }
        flexibleNode.setLength(d);
        return flexibleNode;
    }

    @Override
    FlexibleNode readInternalNode(HashMap<String, Taxon> hashMap) throws IOException, Importer.ImportException {
        FlexibleNode flexibleNode = new FlexibleNode();
        this.readCharacter();
        FlexibleNode flexibleNode2 = this.readBranch(hashMap);
        flexibleNode.addChild(flexibleNode2);
        if (this.getLastDelimiter() != 44) {
            throw new Importer.BadFormatException("Missing ',' in tree in TREES block");
        }
        do {
            flexibleNode.addChild(this.readBranch(hashMap));
        } while (this.getLastDelimiter() == 44);
        if (this.getLastDelimiter() != 41) {
            throw new Importer.BadFormatException("Missing closing ')' in tree in TREES block");
        }
        this.readToken(":(),;");
        if (this.getLastMetaComment() != null) {
            this.parseMigrationString(this.getLastMetaComment(), flexibleNode);
            this.clearLastMetaComment();
        }
        return flexibleNode;
    }

    @Override
    FlexibleNode readExternalNode(HashMap<String, Taxon> hashMap) throws Importer.ImportException, IOException {
        Taxon taxon;
        FlexibleNode flexibleNode = new FlexibleNode();
        String string = this.readToken(":(),;");
        if (hashMap.size() > 0) {
            taxon = hashMap.get(string);
            if (taxon == null) {
                throw new Importer.UnknownTaxonException("Taxon in tree, '" + string + "' is unknown");
            }
        } else {
            taxon = new Taxon(string);
        }
        if (this.getLastMetaComment() != null) {
            this.parseMigrationString(this.getLastMetaComment(), flexibleNode);
            this.clearLastMetaComment();
        }
        flexibleNode.setTaxon(taxon);
        int n = Integer.parseInt(string.split("\\.")[0]);
        flexibleNode.setAttribute(POP, n - 1);
        return flexibleNode;
    }

    private void parseMigrationString(String string, FlexibleNode flexibleNode) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(";")) {
            this.parseMigration(string2, flexibleNode);
        }
    }

    private void parseMigration(String string, FlexibleNode flexibleNode) {
        String[] stringArray = string.split(" ");
        if (!stringArray[0].equals("M")) {
            throw new RuntimeException(stringArray[0] + " should be M");
        }
        int n = Integer.parseInt(stringArray[1]);
        stringArray = stringArray[2].split(":");
        int n2 = Integer.parseInt(stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        if (flexibleNode.getAttribute(TO_POP) == null) {
            flexibleNode.setAttribute(TO_POP, n2);
        }
        flexibleNode.setAttribute(FROM_POP, n);
    }
}

