/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DriftedMuStatistic
extends Statistic.Abstract
implements VariableListener {
    static int MAX_DIM = 30;
    private MatrixParameter mu;
    private TreeModel treeModel;
    private Parameter indicators;
    private Parameter mu1ScaleParameter;
    private Parameter mu2ScaleParameter;
    private Parameter muMeanParameter;
    public static final String DRIFTED_MU_STATISTIC = "driftedMuStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String MU_STRING = "mu";
        public static final String INDICATORS_STRING = "indicators";
        public static final String MU1_SCALE_PARAMETER = "mu1Scale";
        public static final String MU2_SCALE_PARAMETER = "mu2Scale";
        public static final String MU_MEAN_PARAMETER = "muMean";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule("mu", Parameter.class), new ElementRule("indicators", Parameter.class), new ElementRule("mu1Scale", Parameter.class, "Optional parameter for scaling the first dimension of mu"), new ElementRule("mu2Scale", Parameter.class, "Optional parameter for scaling the second dimension of mu"), new ElementRule("muMean", Parameter.class)};

        @Override
        public String getParserName() {
            return DriftedMuStatistic.DRIFTED_MU_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(MU_STRING);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(INDICATORS_STRING);
            Parameter parameter2 = null;
            if (xMLObject.hasChildNamed(MU1_SCALE_PARAMETER)) {
                parameter2 = (Parameter)xMLObject.getElementFirstChild(MU1_SCALE_PARAMETER);
            }
            Parameter parameter3 = null;
            if (xMLObject.hasChildNamed(MU2_SCALE_PARAMETER)) {
                parameter3 = (Parameter)xMLObject.getElementFirstChild(MU2_SCALE_PARAMETER);
            }
            Parameter parameter4 = null;
            if (xMLObject.hasChildNamed(MU_MEAN_PARAMETER)) {
                parameter4 = (Parameter)xMLObject.getElementFirstChild(MU_MEAN_PARAMETER);
            }
            return new DriftedMuStatistic(treeModel, matrixParameter, parameter, parameter2, parameter3, parameter4);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return DriftedMuStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public DriftedMuStatistic(TreeModel treeModel, MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        this.treeModel = treeModel;
        this.mu = matrixParameter;
        this.indicators = parameter;
        this.mu1ScaleParameter = parameter2;
        this.mu1ScaleParameter.addParameterListener(this);
        this.mu2ScaleParameter = parameter3;
        this.mu2ScaleParameter.addParameterListener(this);
        this.muMeanParameter = parameter4;
        this.muMeanParameter.addParameterListener(this);
        matrixParameter.addParameterListener(this);
        parameter.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.treeModel.getNodeCount() * 2;
    }

    @Override
    public double getStatisticValue(int n) {
        int n2 = n / 2;
        double d = this.mu.getParameter(n2).getParameterValue(n % 2);
        d = n % 2 == 0 ? (d *= this.mu1ScaleParameter.getParameterValue(0)) : (d *= this.mu2ScaleParameter.getParameterValue(0));
        return d;
    }

    @Override
    public String getDimensionName(int n) {
        String string = "mu_" + n / 2 + "-" + (n % 2 + 1);
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

