/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.branchmodel.BranchSpecificSubstitutionParameterBranchModel;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModel;
import dr.evomodel.substmodel.DifferentialMassProvider;
import dr.evomodel.tree.TreeParameterModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.ProcessSimulation;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.BranchDifferentialMassProvider;
import dr.evomodel.treedatalikelihood.discrete.BranchSubstitutionParameterDelegate;
import dr.evomodel.treedatalikelihood.preorder.ProcessSimulationDelegate;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.HessianWrtParameterProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.MachineAccuracy;
import dr.math.MultivariateFunction;
import dr.math.NumericalDerivative;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;
import java.io.Serializable;
import java.util.ArrayList;

public class BranchSubstitutionParameterGradient
implements GradientWrtParameterProvider,
HessianWrtParameterProvider,
Reportable,
Loggable {
    protected final TreeDataLikelihood treeDataLikelihood;
    protected final TreeTrait treeTraitProvider;
    protected final Tree tree;
    protected final boolean useHessian;
    protected final CompoundParameter branchParameter;
    private final BranchRateModel branchRateModel;
    protected final TreeParameterModel parameterIndexHelper;
    private static final boolean DEBUG = true;
    protected static final boolean COUNT_TOTAL_OPERATIONS = true;
    protected long getGradientLogDensityCount = 0L;
    protected MultivariateFunction numeric;

    public BranchSubstitutionParameterGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, CompoundParameter compoundParameter, BranchRateModel branchRateModel, boolean bl) {
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        this.branchParameter = compoundParameter;
        this.branchRateModel = branchRateModel;
        this.useHessian = bl;
        this.parameterIndexHelper = new TreeParameterModel((MutableTreeModel)this.tree, new Parameter.Default(this.tree.getNodeCount() - 1), false);
        String string2 = BranchSubstitutionParameterDelegate.getName(string);
        TreeTrait treeTrait = treeDataLikelihood.getTreeTrait(string2);
        if (treeTrait == null) {
            Serializable serializable;
            Serializable serializable2;
            BranchSpecificSubstitutionParameterBranchModel branchSpecificSubstitutionParameterBranchModel = (BranchSpecificSubstitutionParameterBranchModel)beagleDataLikelihoodDelegate.getBranchModel();
            ArrayList<DifferentialMassProvider> arrayList = new ArrayList<DifferentialMassProvider>();
            for (int i = 0; i < this.parameterIndexHelper.getParameterSize(); ++i) {
                serializable2 = this.tree.getNode(this.parameterIndexHelper.getNodeNumberFromParameterIndex(i));
                serializable = (DifferentiableSubstitutionModel)branchSpecificSubstitutionParameterBranchModel.getSubstitutionModel((NodeRef)serializable2);
                Parameter parameter = compoundParameter.getParameter(serializable2.getNumber());
                DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter = serializable.factory(parameter);
                arrayList.add(new DifferentialMassProvider.DifferentialWrapper((DifferentiableSubstitutionModel)serializable, wrtParameter));
            }
            BranchDifferentialMassProvider branchDifferentialMassProvider = new BranchDifferentialMassProvider(this.parameterIndexHelper, arrayList);
            serializable2 = new BranchSubstitutionParameterDelegate(string, treeDataLikelihood.getTree(), beagleDataLikelihoodDelegate, treeDataLikelihood.getBranchRateModel(), branchDifferentialMassProvider);
            serializable = new ProcessSimulation(treeDataLikelihood, (ProcessSimulationDelegate)serializable2);
            treeDataLikelihood.addTraits(serializable.getTreeTraits());
        }
        this.treeTraitProvider = treeDataLikelihood.getTreeTrait(string2);
        assert (this.treeTraitProvider != null);
        int n = treeDataLikelihood.getDataLikelihoodDelegate().getTraitCount();
        if (n != 1) {
            throw new RuntimeException("Not yet implemented for >1 traits");
        }
    }

    @Override
    public double[] getDiagonalHessianLogDensity() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getHessianLogDensity() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Likelihood getLikelihood() {
        return this.treeDataLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.branchParameter;
    }

    @Override
    public int getDimension() {
        return this.branchParameter.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = new double[this.tree.getNodeCount() - 1];
        double[] dArray2 = (double[])this.treeTraitProvider.getTrait(this.tree, null);
        for (int i = 0; i < dArray.length; ++i) {
            double d;
            NodeRef nodeRef = this.tree.getNode(this.parameterIndexHelper.getNodeNumberFromParameterIndex(i));
            int n = this.parameterIndexHelper.getParameterIndexFromNodeNumber(nodeRef.getNumber());
            dArray[n] = d = dArray2[i] * this.getChainGradient(this.tree, nodeRef);
        }
        ++this.getGradientLogDensityCount;
        return dArray;
    }

    protected double getChainGradient(Tree tree, NodeRef nodeRef) {
        double d = this.branchParameter.getParameterValue(nodeRef.getNumber());
        if (this.branchRateModel instanceof ArbitraryBranchRates) {
            return ((ArbitraryBranchRates)this.branchRateModel).getTransform().differential(d, tree, nodeRef);
        }
        return 1.0;
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[]{new LogColumn.Default("gradient report", new Object(){

            public String toString() {
                return "\n" + BranchSubstitutionParameterGradient.this.getReport();
            }
        })};
        return logColumnArray;
    }

    private MultivariateFunction numericWrap(final Parameter parameter) {
        return new MultivariateFunction(){

            @Override
            public double evaluate(double[] dArray) {
                if (!(BranchSubstitutionParameterGradient.this.branchRateModel instanceof ArbitraryBranchRates)) {
                    throw new RuntimeException("Not yet tested with ProxyParameter.");
                }
                ArbitraryBranchRates arbitraryBranchRates = (ArbitraryBranchRates)BranchSubstitutionParameterGradient.this.branchRateModel;
                Tree tree = BranchSubstitutionParameterGradient.this.treeDataLikelihood.getTree();
                for (int i = 0; i < dArray.length; ++i) {
                    NodeRef nodeRef = tree.getNode(i);
                    if (tree.isRoot(nodeRef)) continue;
                    arbitraryBranchRates.setBranchRate(tree, tree.getNode(i), dArray[i]);
                }
                return BranchSubstitutionParameterGradient.this.treeDataLikelihood.getLogLikelihood();
            }

            @Override
            public int getNumArguments() {
                return parameter.getDimension();
            }

            @Override
            public double getLowerBound(int n) {
                return 0.0;
            }

            @Override
            public double getUpperBound(int n) {
                return Double.POSITIVE_INFINITY;
            }
        };
    }

    protected boolean valuesAreSufficientlyLarge(double[] dArray) {
        for (double d : dArray) {
            if (!(Math.abs(d) < MachineAccuracy.SQRT_EPSILON * 1.2)) continue;
            return false;
        }
        return true;
    }

    protected String getReport(Parameter parameter) {
        double[] dArray = parameter.getParameterValues();
        double[] dArray2 = null;
        double[] dArray3 = null;
        boolean bl = this.valuesAreSufficientlyLarge(parameter.getParameterValues());
        this.numeric = this.numericWrap(parameter);
        if (bl) {
            dArray2 = NumericalDerivative.gradient(this.numeric, parameter.getParameterValues());
        }
        if (this.useHessian && bl) {
            dArray3 = NumericalDerivative.diagonalHessian(this.numeric, parameter.getParameterValues());
        }
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValue(i, dArray[i]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Gradient Peeling: ").append(new Vector(this.getGradientLogDensity()));
        stringBuilder.append("\n");
        if (dArray2 != null && bl) {
            stringBuilder.append("Gradient numeric: ").append(new Vector(dArray2));
        } else {
            stringBuilder.append("Gradient mumeric: too close to 0");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public String getReport() {
        return this.getReport(this.branchParameter);
    }
}

