/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood;

import beagle.Beagle;
import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.siteratemodel.GammaSiteRateModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treelikelihood.AbstractSinglePartitionTreeLikelihood;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.math.matrixAlgebra.Vector;
import java.io.PrintWriter;

public class BeagleOperationReport
extends AbstractSinglePartitionTreeLikelihood {
    protected PatternList patternList = null;
    protected DataType dataType = null;
    protected double[] patternWeights;
    protected int patternCount;
    protected int stateCount;
    protected boolean[] updatePattern = null;
    private int eigenCount = 1;
    private int[][] matrixUpdateIndices;
    private double[][] branchLengths;
    private int[] branchUpdateCount;
    private int[] scaleBufferIndices;
    private int[] storedScaleBufferIndices;
    private int[][] operations;
    private int operationListCount;
    private int[] operationCount;
    private static final boolean hasRestrictedPartials = false;
    private final int numRestrictedPartials = 0;
    protected BufferIndexHelper partialBufferHelper;
    private final BufferIndexHelper eigenBufferHelper;
    protected BufferIndexHelper matrixBufferHelper;
    protected BufferIndexHelper scaleBufferHelper;
    protected final int tipCount;
    protected final int internalNodeCount;
    private PartialsRescalingScheme rescalingScheme;
    protected boolean useScaleFactors = false;
    private boolean useAutoScaling = false;
    private boolean recomputeScaleFactors = false;
    private boolean everUnderflowed = false;
    private int rescalingCount = 0;
    private int rescalingCountInner = 0;
    protected final BranchRateModel branchRateModel;
    protected double[] patternLogLikelihoods = null;
    protected int categoryCount;
    protected double[] tipPartials;
    protected int[] tipStates;
    protected Beagle beagle;
    protected boolean updateSubstitutionModel;
    protected boolean updateSiteModel;
    private static final boolean DEBUG_BEAGLE_OPERATIONS = true;
    private static final boolean SINGLE_LINE = true;
    private StringBuilder alignmentString;
    private final PrintWriter branchWriter;
    private final PrintWriter operationWriter;
    private final SubstitutionModel substitutionModel;
    private final Alignment alignment;

    public BeagleOperationReport(TreeModel treeModel, PatternList patternList, BranchRateModel branchRateModel, GammaSiteRateModel gammaSiteRateModel, Alignment alignment, PrintWriter printWriter, PrintWriter printWriter2) {
        super("beagleOperationReport", patternList, treeModel);
        boolean bl = false;
        this.branchRateModel = branchRateModel;
        this.branchWriter = printWriter;
        this.operationWriter = printWriter2;
        this.alignment = alignment;
        this.substitutionModel = gammaSiteRateModel.getSubstitutionModel();
        try {
            this.tipCount = treeModel.getExternalNodeCount();
            this.internalNodeCount = this.nodeCount - this.tipCount;
            int n = this.tipCount;
            this.partialBufferHelper = new BufferIndexHelper(this.nodeCount, this.tipCount);
            this.eigenBufferHelper = new BufferIndexHelper(this.eigenCount, 0);
            this.matrixBufferHelper = new BufferIndexHelper(this.nodeCount, 0);
            for (int i = 0; i < this.tipCount; ++i) {
                String string = treeModel.getTaxonId(i);
                int n2 = patternList.getTaxonIndex(string);
                if (n2 == -1) {
                    throw new TaxonList.MissingTaxonException("Taxon, " + string + ", in tree, " + treeModel.getId() + ", is not found in patternList, " + patternList.getId());
                }
                if (bl) {
                    this.setPartials(this.beagle, patternList, n2, i);
                    continue;
                }
                this.setStates(this.beagle, patternList, string, n2, i);
            }
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
        this.hasInitialized = true;
    }

    @Override
    public String toString() {
        this.calculateLogLikelihood();
        return super.toString();
    }

    public MutableTreeModel getTreeModel() {
        return this.treeModel;
    }

    protected final void setPartials(Beagle beagle, PatternList patternList, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double[] dArray = new double[this.patternCount * this.stateCount * this.categoryCount];
        int n6 = 0;
        for (n5 = 0; n5 < this.patternCount; ++n5) {
            n4 = patternList.getPatternState(n, n5);
            boolean[] blArray = this.dataType.getStateSet(n4);
            for (n3 = 0; n3 < this.stateCount; ++n3) {
                dArray[n6] = blArray[n3] ? 1.0 : 0.0;
                ++n6;
            }
        }
        n4 = n5 = this.patternCount * this.stateCount;
        for (n3 = 1; n3 < this.categoryCount; ++n3) {
            System.arraycopy(dArray, 0, dArray, n4, n5);
            n4 += n5;
        }
        System.err.println("TODO Print partials");
    }

    protected final void setPartials(Beagle beagle, TipStatesModel tipStatesModel, int n) {
        int n2;
        double[] dArray = new double[this.patternCount * this.stateCount * this.categoryCount];
        tipStatesModel.getTipPartials(n, dArray);
        int n3 = n2 = this.patternCount * this.stateCount;
        for (int i = 1; i < this.categoryCount; ++i) {
            System.arraycopy(dArray, 0, dArray, n3, n2);
            n3 += n2;
        }
        System.err.println("TODO Print partials");
    }

    public int getPatternCount() {
        return this.patternCount;
    }

    protected final void setStates(Beagle beagle, PatternList patternList, String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/* ").append(string).append(" */\n\t\tmSeqs[").append(n2).append("] = \"");
        stringBuilder.append(this.alignment.getAlignedSequenceString(n)).append("\";\n");
        int[] nArray = new int[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            nArray[i] = patternList.getPatternState(n, i);
        }
        if (this.alignmentString == null) {
            this.alignmentString = new StringBuilder();
        }
        this.alignmentString.append((CharSequence)stringBuilder);
    }

    @Override
    protected double calculateLogLikelihood() {
        if (this.matrixUpdateIndices == null) {
            this.matrixUpdateIndices = new int[this.eigenCount][this.nodeCount];
            this.branchLengths = new double[this.eigenCount][this.nodeCount];
            this.branchUpdateCount = new int[this.eigenCount];
        }
        if (this.operations == null) {
            this.operations = new int[1][this.internalNodeCount * 7];
            this.operationCount = new int[1];
        }
        this.recomputeScaleFactors = false;
        for (int i = 0; i < this.eigenCount; ++i) {
            this.branchUpdateCount[i] = 0;
        }
        this.operationListCount = 0;
        this.operationCount[0] = 0;
        System.out.println(this.alignmentString.toString());
        NodeRef nodeRef = this.treeModel.getRoot();
        this.traverse(this.treeModel, nodeRef, null, false);
        for (int i = 0; i < this.eigenCount; ++i) {
            int n;
            if (this.branchUpdateCount[i] <= 0) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("eval = ").append(new Vector(this.substitutionModel.getEigenDecomposition().getEigenValues())).append("\n");
            stringBuilder.append("evec = ").append(new Vector(this.substitutionModel.getEigenDecomposition().getEigenVectors())).append("\n");
            stringBuilder.append("ivec = ").append(new Vector(this.substitutionModel.getEigenDecomposition().getInverseEigenVectors())).append("\n");
            stringBuilder.append("Branch count: ").append(this.branchUpdateCount[i]);
            stringBuilder.append("\nNode indices:\n");
            stringBuilder.append("int n[] = {");
            for (n = 0; n < this.branchUpdateCount[i]; ++n) {
                stringBuilder.append(" ").append(this.matrixUpdateIndices[i][n]);
                if (n >= this.branchUpdateCount[i] - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(" };\n");
            stringBuilder.append("\nBranch lengths:\n");
            stringBuilder.append("double b[] = {");
            for (n = 0; n < this.branchUpdateCount[i]; ++n) {
                stringBuilder.append(" ").append(this.branchLengths[i][n]);
                if (n >= this.branchUpdateCount[i] - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(" };\n");
            System.out.println(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Operation count: ").append(this.operationCount[0]);
        stringBuilder.append("\nOperations:\n");
        stringBuilder.append("BeagleOperation o[] = {");
        for (int i = 0; i < this.operationCount[0] * 7; ++i) {
            stringBuilder.append(" ").append(this.operations[0][i]);
            if (i >= this.operationCount[0] * 7 - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(" };\n");
        stringBuilder.append("Use scale factors: ").append(this.useScaleFactors).append("\n");
        System.out.println(stringBuilder.toString());
        int n = this.partialBufferHelper.getOffsetIndex(nodeRef.getNumber());
        System.out.println("Root node: " + n);
        return 0.0;
    }

    private boolean traverse(Tree tree, NodeRef nodeRef, int[] nArray, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nArray != null) {
            nArray[0] = -1;
        }
        if (nodeRef2 != null && this.updateNode[n2]) {
            double d = this.branchRateModel.getBranchRate(tree, nodeRef);
            double d2 = d * (tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef));
            if (d2 < 0.0) {
                throw new RuntimeException("Negative branch length: " + d2);
            }
            if (bl) {
                this.matrixBufferHelper.flipOffset(n2);
            }
            n = this.branchUpdateCount[0];
            this.matrixUpdateIndices[0][n] = this.matrixBufferHelper.getOffsetIndex(n2);
            this.branchLengths[0][n] = d2;
            this.branchUpdateCount[0] = this.branchUpdateCount[0] + 1;
            bl2 = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            int[] nArray2 = new int[]{-1};
            boolean bl3 = this.traverse(tree, nodeRef3, nArray2, bl);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            int[] nArray3 = new int[]{-1};
            n = this.traverse(tree, nodeRef4, nArray3, bl) ? 1 : 0;
            if (bl3 || n != 0) {
                int n3 = this.operationCount[this.operationListCount] * 7;
                if (bl) {
                    this.partialBufferHelper.flipOffset(n2);
                }
                int[] nArray4 = this.operations[this.operationListCount];
                nArray4[n3] = this.partialBufferHelper.getOffsetIndex(n2);
                if (this.useScaleFactors) {
                    int n4 = n2 - this.tipCount;
                    if (this.recomputeScaleFactors) {
                        this.scaleBufferHelper.flipOffset(n4);
                        this.scaleBufferIndices[n4] = this.scaleBufferHelper.getOffsetIndex(n4);
                        nArray4[n3 + 1] = this.scaleBufferIndices[n4];
                        nArray4[n3 + 2] = -1;
                    } else {
                        nArray4[n3 + 1] = -1;
                        nArray4[n3 + 2] = this.scaleBufferIndices[n4];
                    }
                } else {
                    if (this.useAutoScaling) {
                        this.scaleBufferIndices[n2 - this.tipCount] = this.partialBufferHelper.getOffsetIndex(n2);
                    }
                    nArray4[n3 + 1] = -1;
                    nArray4[n3 + 2] = -1;
                }
                nArray4[n3 + 3] = this.partialBufferHelper.getOffsetIndex(nodeRef3.getNumber());
                nArray4[n3 + 4] = this.matrixBufferHelper.getOffsetIndex(nodeRef3.getNumber());
                nArray4[n3 + 5] = this.partialBufferHelper.getOffsetIndex(nodeRef4.getNumber());
                nArray4[n3 + 6] = this.matrixBufferHelper.getOffsetIndex(nodeRef4.getNumber());
                int n5 = this.operationListCount;
                this.operationCount[n5] = this.operationCount[n5] + 1;
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    protected void updatePattern(int n) {
        if (this.updatePattern != null) {
            this.updatePattern[n] = true;
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void updateAllPatterns() {
        if (this.updatePattern != null) {
            for (int i = 0; i < this.patternCount; ++i) {
                this.updatePattern[i] = true;
            }
        }
        this.likelihoodKnown = false;
    }

    protected class BufferIndexHelper {
        private final int maxIndexValue;
        private final int minIndexValue;
        private final int offsetCount;
        private int[] indexOffsets;
        private int[] storedIndexOffsets;

        BufferIndexHelper(int n, int n2) {
            this.maxIndexValue = n;
            this.minIndexValue = n2;
            this.offsetCount = n - n2;
            this.indexOffsets = new int[this.offsetCount];
            this.storedIndexOffsets = new int[this.offsetCount];
        }

        public int getBufferCount() {
            return 2 * this.offsetCount + this.minIndexValue;
        }

        void flipOffset(int n) {
            if (n >= this.minIndexValue) {
                this.indexOffsets[n - this.minIndexValue] = this.offsetCount - this.indexOffsets[n - this.minIndexValue];
            }
        }

        int getOffsetIndex(int n) {
            if (n < this.minIndexValue) {
                return n;
            }
            return this.indexOffsets[n - this.minIndexValue] + n;
        }

        void getIndices(int[] nArray) {
            for (int i = 0; i < this.maxIndexValue; ++i) {
                nArray[i] = this.getOffsetIndex(i);
            }
        }

        void storeState() {
            System.arraycopy(this.indexOffsets, 0, this.storedIndexOffsets, 0, this.indexOffsets.length);
        }

        void restoreState() {
            int[] nArray = this.storedIndexOffsets;
            this.storedIndexOffsets = this.indexOffsets;
            this.indexOffsets = nArray;
        }
    }
}

