/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.CauchyDistributionImpl;

public class CauchyDistribution
extends AbstractContinuousDistribution
implements Distribution {
    CauchyDistributionImpl distribution;
    double median;
    double scale;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return CauchyDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };

    public CauchyDistribution(double d, double d2) {
        this.distribution = new CauchyDistributionImpl(d, d2);
        this.median = d;
        this.scale = d2;
    }

    @Override
    public double pdf(double d) {
        return this.distribution.density(d);
    }

    @Override
    public double logPdf(double d) {
        return Math.log(this.distribution.density(d));
    }

    @Override
    public double cdf(double d) {
        return this.distribution.cumulativeProbability(d);
    }

    @Override
    public double quantile(double d) {
        return this.distribution.inverseCumulativeProbability(d);
    }

    @Override
    public double mean() {
        return Double.NaN;
    }

    @Override
    public double variance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    protected double getInitialDomain(double d) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        return 0.0;
    }
}

