/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.DiagonalMatrix;
import dr.inference.model.DuplicatedParameter;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.math.distributions.MultivariateNormalDistribution;

public class MultivariateNormalDistributionModel
extends AbstractModel
implements ParametricMultivariateDistributionModel,
GaussianProcessRandomGenerator,
GradientProvider,
HessianProvider {
    private final Parameter mean;
    private final MatrixParameter precision;
    private final boolean hasSinglePrecision;
    private final Parameter singlePrecision;
    private MultivariateNormalDistribution distribution;
    private MultivariateNormalDistribution storedDistribution;
    private boolean distributionKnown;
    private boolean storedDistributionKnown;

    public MultivariateNormalDistributionModel(Parameter parameter, MatrixParameter matrixParameter) {
        super("multivariateNormalDistributionModel");
        DiagonalMatrix diagonalMatrix;
        this.mean = parameter;
        this.addVariable(parameter);
        if (!(parameter instanceof DuplicatedParameter)) {
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, parameter.getDimension()));
        }
        this.precision = matrixParameter;
        this.addVariable(matrixParameter);
        Parameter parameter2 = null;
        if (matrixParameter instanceof DiagonalMatrix && (diagonalMatrix = (DiagonalMatrix)matrixParameter).getDiagonalParameter() instanceof DuplicatedParameter) {
            parameter2 = diagonalMatrix.getDiagonalParameter();
        }
        this.hasSinglePrecision = parameter2 != null;
        this.singlePrecision = parameter2;
        this.distribution = this.createNewDistribution();
        this.distributionKnown = true;
    }

    public MatrixParameter getPrecisionMatrixParameter() {
        return this.precision;
    }

    public Parameter getMeanParameter() {
        return this.mean;
    }

    private void checkDistribution() {
        if (!this.distributionKnown) {
            this.distribution = this.createNewDistribution();
            this.distributionKnown = true;
        }
    }

    @Override
    public double logPdf(double[] dArray) {
        this.checkDistribution();
        return this.distribution.logPdf(dArray);
    }

    @Override
    public double[][] getScaleMatrix() {
        return this.precision.getParameterAsMatrix();
    }

    @Override
    public double[] getMean() {
        return this.mean.getParameterValues();
    }

    @Override
    public String getType() {
        return this.distribution.getType();
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.distributionKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedDistribution = this.distribution;
        this.storedDistributionKnown = this.distributionKnown;
    }

    @Override
    protected void restoreState() {
        this.distributionKnown = this.storedDistributionKnown;
        this.distribution = this.storedDistribution;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public int getDimension() {
        return this.mean.getDimension();
    }

    @Override
    public double[][] getPrecisionMatrix() {
        return this.precision.getParameterAsMatrix();
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.mean;
    }

    private MultivariateNormalDistribution createNewDistribution() {
        if (this.hasSinglePrecision) {
            return new MultivariateNormalDistribution(this.getMean(), this.singlePrecision.getParameterValue(0));
        }
        return new MultivariateNormalDistribution(this.getMean(), this.getScaleMatrix());
    }

    @Override
    public double[] nextRandom() {
        this.checkDistribution();
        return this.distribution.nextMultivariateNormal();
    }

    @Override
    public double logPdf(Object object) {
        this.checkDistribution();
        return this.distribution.logPdf(object);
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getGradientLogDensity(object);
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getDiagonalHessianLogDensity(object);
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getHessianLogDensity(object);
    }
}

