/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.TruncatedNormalDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TruncatedNormalDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return TruncatedNormalDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Variable<Double> mean;
    private final Variable<Double> stdev;
    private final Variable<Double> minimum;
    private final Variable<Double> maximum;
    private Variable<Double> precision;
    private boolean hasPrecision = false;
    private TruncatedNormalDistribution distribution = null;
    private TruncatedNormalDistribution storedDistribution = null;

    public TruncatedNormalDistributionModel(Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4) {
        super("truncatedNormalDistributionModel");
        this.mean = variable;
        this.stdev = variable2;
        this.minimum = variable3;
        this.maximum = variable4;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(variable3);
        variable3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(variable4);
        variable4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.recomputeTruncatedNormalDistribution();
    }

    public TruncatedNormalDistributionModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, boolean bl) {
        super("normalDistributionModel");
        this.minimum = parameter3;
        this.maximum = parameter4;
        this.hasPrecision = bl;
        this.mean = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        if (bl) {
            this.precision = parameter2;
            this.stdev = null;
        } else {
            this.stdev = parameter2;
        }
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.recomputeTruncatedNormalDistribution();
    }

    public double getStdev() {
        if (this.hasPrecision) {
            return 1.0 / Math.sqrt(this.precision.getValue(0));
        }
        return this.stdev.getValue(0);
    }

    public Variable<Double> getMean() {
        return this.mean;
    }

    public Variable<Double> getMaximum() {
        return this.maximum;
    }

    public Variable<Double> getMinimum() {
        return this.minimum;
    }

    public Variable<Double> getPrecision() {
        if (this.hasPrecision) {
            return this.precision;
        }
        return null;
    }

    @Override
    public double pdf(double d) {
        return this.distribution.pdf(d);
    }

    @Override
    public double logPdf(double d) {
        return this.distribution.logPdf(d);
    }

    @Override
    public double cdf(double d) {
        return this.distribution.cdf(d);
    }

    @Override
    public double quantile(double d) {
        return this.distribution.quantile(d);
    }

    @Override
    public double mean() {
        return this.mean.getValue(0);
    }

    public double minimum() {
        return this.minimum.getValue(0);
    }

    public double maximum() {
        return this.maximum.getValue(0);
    }

    @Override
    public double variance() {
        if (this.hasPrecision) {
            return 1.0 / this.precision.getValue(0);
        }
        double d = this.stdev.getValue(0);
        return d * d;
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    private void recomputeTruncatedNormalDistribution() {
        this.distribution = new TruncatedNormalDistribution(this.mean.getValue(0), this.stdev.getValue(0), this.minimum.getValue(0), this.maximum.getValue(0));
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.mean;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.recomputeTruncatedNormalDistribution();
    }

    @Override
    protected void storeState() {
        this.storedDistribution = this.distribution;
    }

    @Override
    protected void restoreState() {
        this.distribution = this.storedDistribution;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

