/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution.shrinkage;

import dr.inference.distribution.shrinkage.BayesianBridgeDistributionModel;
import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.distribution.shrinkage.JointBayesianBridgeDistributionModel;
import dr.inference.distribution.shrinkage.MarginalBayesianBridgeDistributionModel;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class BayesianBridgeLikelihood
extends AbstractModelLikelihood
implements BayesianBridgeStatisticsProvider,
GradientWrtParameterProvider {
    private final Parameter coefficients;
    private final BayesianBridgeDistributionModel distribution;
    private final int dim;

    public BayesianBridgeLikelihood(Parameter parameter, BayesianBridgeDistributionModel bayesianBridgeDistributionModel) {
        super("bayesianBridge");
        this.coefficients = parameter;
        this.distribution = bayesianBridgeDistributionModel;
        this.dim = parameter.getDimension();
        this.addModel(bayesianBridgeDistributionModel);
        this.addVariable(parameter);
    }

    @Override
    public Parameter getGlobalScale() {
        return this.distribution.getGlobalScale();
    }

    @Override
    public Parameter getExponent() {
        return this.distribution.getExponent();
    }

    @Override
    public Parameter getLocalScale() {
        return this.distribution.getLocalScale();
    }

    @Override
    public double getCoefficient(int n) {
        return this.coefficients.getParameterValue(n);
    }

    @Override
    public double getLogLikelihood() {
        return this.distribution.logPdf(this.coefficients.getParameterValues());
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.distribution.gradientLogPdf(this.coefficients.getParameterValues());
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public Parameter getParameter() {
        return this.coefficients;
    }

    @Override
    public final void makeDirty() {
    }

    @Override
    public final void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public void storeState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = super.getColumns();
        boolean bl = this.distribution instanceof JointBayesianBridgeDistributionModel;
        LogColumn[] logColumnArray2 = new LogColumn[logColumnArray.length + (bl ? 1 : 0)];
        System.arraycopy(logColumnArray, 0, logColumnArray2, 0, logColumnArray.length);
        if (bl) {
            logColumnArray2[logColumnArray.length] = new NumberColumn(this.getId() + ".marginalized"){

                @Override
                public double getDoubleValue() {
                    double[] dArray = BayesianBridgeLikelihood.this.coefficients.getParameterValues();
                    double d = BayesianBridgeLikelihood.this.distribution.getGlobalScale().getParameterValue(0);
                    double d2 = BayesianBridgeLikelihood.this.distribution.getExponent().getParameterValue(0);
                    return MarginalBayesianBridgeDistributionModel.logPdf(dArray, d, d2);
                }
            };
        }
        return logColumnArray2;
    }
}

