/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovchain;

import dr.evomodel.continuous.GibbsIndependentCoalescentOperator;
import dr.inference.markovchain.Acceptor;
import dr.inference.markovchain.MarkovChainListener;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.PathLikelihood;
import dr.inference.model.Profileable;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.GeneralOperator;
import dr.inference.operators.GibbsIndependentGammaOperator;
import dr.inference.operators.GibbsIndependentJointNormalGammaOperator;
import dr.inference.operators.GibbsIndependentNormalDistributionOperator;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class MarkovChain
implements Serializable {
    private static final long serialVersionUID = 181L;
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = true;
    public static final double EVALUATION_TEST_THRESHOLD = 0.1;
    private final OperatorSchedule schedule;
    private final Acceptor acceptor;
    private final Likelihood likelihood;
    private boolean pleaseStop = false;
    private boolean isStopped = false;
    private double bestScore;
    private double currentScore;
    private double initialScore;
    private long currentLength = 0L;
    private final boolean useAdaptation;
    private boolean isCurrentlyAdapting;
    private final boolean useSmoothedAcceptanceProbability;
    private final long fullEvaluationCount;
    private final int minOperatorCountForFullEvaluation;
    private double evaluationTestThreshold = 0.1;
    private final ArrayList<MarkovChainListener> listeners = new ArrayList();

    public MarkovChain(Likelihood likelihood, OperatorSchedule operatorSchedule, Acceptor acceptor, long l, int n, double d, boolean bl, boolean bl2) {
        this.likelihood = likelihood;
        this.schedule = operatorSchedule;
        this.acceptor = acceptor;
        this.useAdaptation = bl;
        this.isCurrentlyAdapting = bl;
        this.useSmoothedAcceptanceProbability = bl2;
        this.fullEvaluationCount = l;
        this.minOperatorCountForFullEvaluation = n;
        this.evaluationTestThreshold = d;
        Likelihood.CONNECTED_LIKELIHOOD_SET.add(likelihood);
        Likelihood.CONNECTED_LIKELIHOOD_SET.addAll(likelihood.getLikelihoodSet());
        for (Likelihood likelihood2 : Likelihood.FULL_LIKELIHOOD_SET) {
            if (Likelihood.CONNECTED_LIKELIHOOD_SET.contains(likelihood2)) continue;
            System.err.println("WARNING: Likelihood component, " + likelihood2.getId() + ", created but not used in the MCMC");
        }
        this.currentScore = this.evaluate(likelihood);
    }

    public void reset() {
        this.currentLength = 0L;
        for (int i = 0; i < this.schedule.getOperatorCount(); ++i) {
            this.schedule.getOperator(i).reset();
        }
    }

    public long runChain(long l, boolean bl) {
        this.isCurrentlyAdapting = this.useAdaptation && !bl;
        this.likelihood.makeDirty();
        this.currentScore = this.evaluate(this.likelihood);
        long l2 = this.currentLength;
        Model model = this.likelihood.getModel();
        if (l2 == 0L) {
            this.initialScore = this.currentScore;
            this.bestScore = this.currentScore;
            this.fireBestModel(l2, model);
        }
        if (this.currentScore == Double.NEGATIVE_INFINITY) {
            String string = "The initial likelihood is zero";
            if (this.likelihood instanceof CompoundLikelihood) {
                string = string + ": " + ((CompoundLikelihood)this.likelihood).getDiagnosis();
            } else if (this.likelihood instanceof PathLikelihood) {
                string = string + ": " + ((CompoundLikelihood)((PathLikelihood)this.likelihood).getSourceLikelihood()).getDiagnosis();
                string = string + ": " + ((CompoundLikelihood)((PathLikelihood)this.likelihood).getDestinationLikelihood()).getDiagnosis();
            } else {
                string = string + ".";
            }
            throw new IllegalArgumentException(string);
        }
        if (this.currentScore == Double.POSITIVE_INFINITY || Double.isNaN(this.currentScore)) {
            String string = "A likelihood returned with a numerical error (" + this.currentScore + ")";
            if (this.likelihood instanceof CompoundLikelihood) {
                string = string + ": " + ((CompoundLikelihood)this.likelihood).getDiagnosis();
            } else {
                string = string + ".";
                Set<Likelihood> set = this.likelihood.getLikelihoodSet();
                for (Likelihood likelihood : set) {
                    string = string + "\n  " + likelihood.prettyName() + " = " + likelihood.getLogLikelihood();
                }
            }
            throw new IllegalArgumentException(string);
        }
        this.pleaseStop = false;
        this.isStopped = false;
        double[] dArray = new double[]{0.0};
        boolean bl2 = true;
        if (this.fullEvaluationCount == 0L) {
            bl2 = false;
        }
        boolean bl3 = false;
        HashMap<String, Double> hashMap = null;
        while (!this.pleaseStop && l2 < this.currentLength + l) {
            this.fireCurrentModel(l2, model);
            if (this.pleaseStop) {
                this.isStopped = true;
                break;
            }
            int n = this.schedule.getNextOperatorIndex();
            MCMCOperator mCMCOperator = this.schedule.getOperator(n);
            double d = this.currentScore;
            if (bl2) {
                hashMap = new HashMap<String, Double>();
                this.fillDensities(this.likelihood, hashMap);
            }
            if (model != null) {
                model.storeModelState();
            }
            boolean bl4 = true;
            double d2 = 1.0;
            boolean bl5 = false;
            dArray[0] = -1.7976931348623157E308;
            d2 = mCMCOperator instanceof GeneralOperator ? ((GeneralOperator)((Object)mCMCOperator)).operate(this.likelihood) : mCMCOperator.operate();
            if (d2 == Double.NEGATIVE_INFINITY) {
                bl4 = false;
            }
            double d3 = Double.NaN;
            double d4 = Double.NaN;
            if (bl4) {
                long l3 = 0L;
                long l4 = 0L;
                l3 = System.currentTimeMillis();
                if (this.likelihood instanceof Profileable) {
                    l4 = ((Profileable)((Object)this.likelihood)).getTotalCalculationCount();
                }
                d3 = this.evaluate(this.likelihood);
                long l5 = System.currentTimeMillis() - l3;
                mCMCOperator.addEvaluationTime(l5);
                long l6 = this.likelihood instanceof Profileable ? ((Profileable)((Object)this.likelihood)).getTotalCalculationCount() : 1L;
                mCMCOperator.addCalculationCount(l6 - l4);
                Object object = null;
                if (bl2) {
                    object = new HashMap<String, Double>();
                    this.fillDensities(this.likelihood, (Map<String, Double>)object);
                }
                if (!(d3 != Double.NEGATIVE_INFINITY || !(mCMCOperator instanceof GibbsOperator) || mCMCOperator instanceof GibbsIndependentNormalDistributionOperator || mCMCOperator instanceof GibbsIndependentGammaOperator || mCMCOperator instanceof GibbsIndependentCoalescentOperator || mCMCOperator instanceof GibbsIndependentJointNormalGammaOperator)) {
                    Logger.getLogger("error").severe("State " + l2 + ": A Gibbs operator, " + mCMCOperator.getOperatorName() + ", returned a state with zero likelihood.");
                }
                if (d3 == Double.POSITIVE_INFINITY || Double.isNaN(d3)) {
                    if (this.likelihood instanceof CompoundLikelihood) {
                        Logger.getLogger("error").severe("State " + l2 + ": A likelihood returned with a numerical error:\n" + ((CompoundLikelihood)this.likelihood).getDiagnosis());
                    } else {
                        Logger.getLogger("error").severe("State " + l2 + ": A likelihood returned with a numerical error.");
                    }
                    d3 = Double.NEGATIVE_INFINITY;
                }
                if (bl2) {
                    this.likelihood.makeDirty();
                    double d5 = this.evaluate(this.likelihood);
                    HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
                    this.fillDensities(this.likelihood, hashMap2);
                    if (Math.abs(d5 - d3) > this.evaluationTestThreshold) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("State " + l2 + ": State was not correctly calculated after an operator move.\nLikelihood evaluation: " + d3 + "\nFull Likelihood evaluation: " + d5 + "\nOperator: " + mCMCOperator + " " + mCMCOperator.getOperatorName() + "\n\n");
                        stringBuilder.append("Discrepancies:\n");
                        for (String string : object.keySet()) {
                            if (!(Math.abs((Double)object.get(string) - (Double)hashMap2.get(string)) > this.evaluationTestThreshold)) continue;
                            stringBuilder.append(string + ": " + object.get(string) + " -> " + hashMap2.get(string) + "\n");
                        }
                        stringBuilder.append("\n");
                        Logger.getLogger("error").severe(stringBuilder.toString());
                        bl3 = true;
                    }
                }
                if (d3 > this.bestScore) {
                    this.bestScore = d3;
                    this.fireBestModel(l2, model);
                }
                bl5 = mCMCOperator instanceof GibbsOperator || this.acceptor.accept(d, d3, d2, dArray);
                d4 = d3 - d;
            }
            if (bl5) {
                mCMCOperator.accept(d4);
                model.acceptModelState();
                this.currentScore = d3;
            } else {
                mCMCOperator.reject();
                model.restoreModelState();
                if (bl2) {
                    this.likelihood.makeDirty();
                    double d6 = this.evaluate(this.likelihood);
                    HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
                    this.fillDensities(this.likelihood, hashMap3);
                    if (Math.abs(d6 - d) > this.evaluationTestThreshold) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("State " + l2 + ": State was not correctly restored after reject step.\nLikelihood before: " + d + " Likelihood after: " + d6 + "\nOperator: " + mCMCOperator + " " + mCMCOperator.getOperatorName() + "\n\n");
                        stringBuilder.append("Discrepancies:\n");
                        for (String string : hashMap.keySet()) {
                            if (!(Math.abs((Double)hashMap.get(string) - (Double)hashMap3.get(string)) > this.evaluationTestThreshold)) continue;
                            stringBuilder.append(string + ": " + hashMap.get(string) + " -> " + hashMap3.get(string) + "\n");
                        }
                        stringBuilder.append("\n");
                        Logger.getLogger("error").severe(stringBuilder.toString());
                        bl3 = true;
                    }
                }
            }
            if (this.isAdapting(mCMCOperator)) {
                this.adaptAcceptanceProbability((AdaptableMCMCOperator)mCMCOperator, dArray[0]);
            }
            if (bl2 && this.schedule.getMinimumAcceptAndRejectCount() >= (long)this.minOperatorCountForFullEvaluation && l2 >= this.fullEvaluationCount) {
                bl2 = false;
                if (bl3) {
                    throw new RuntimeException("One or more evaluation errors occurred during the test phase of this\nrun. These errors imply critical errors which may produce incorrect\nresults.");
                }
            }
            this.fireEndCurrentIteration(l2);
            ++l2;
        }
        this.currentLength = l2;
        return this.currentLength;
    }

    public void terminateChain() {
        this.fireFinished(this.currentLength);
    }

    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    public Model getModel() {
        return this.likelihood.getModel();
    }

    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public double getInitialScore() {
        return this.initialScore;
    }

    public double getBestScore() {
        return this.bestScore;
    }

    public long getCurrentLength() {
        return this.currentLength;
    }

    public void setCurrentLength(long l) {
        this.currentLength = l;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public void pleaseStop() {
        this.pleaseStop = true;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public double evaluate() {
        return this.evaluate(this.likelihood);
    }

    protected double evaluate(Likelihood likelihood) {
        double d = 0.0;
        double d2 = likelihood.getLogLikelihood();
        if (Double.isNaN(d2)) {
            return Double.NEGATIVE_INFINITY;
        }
        return d += d2;
    }

    public boolean isAdapting(MCMCOperator mCMCOperator) {
        return this.isCurrentlyAdapting && mCMCOperator instanceof AdaptableMCMCOperator;
    }

    public void adaptAcceptanceProbability(AdaptableMCMCOperator adaptableMCMCOperator, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl;
        boolean bl2 = bl = adaptableMCMCOperator.getMode() == AdaptationMode.ADAPTATION_ON || adaptableMCMCOperator.getMode() != AdaptationMode.ADAPTATION_OFF;
        if (bl && (d6 = (d5 = adaptableMCMCOperator.getAdaptableParameter()) + 1.0 / (d4 = this.schedule.getOptimizationTransform().transform(adaptableMCMCOperator.getAdaptationCount() + 2L)) * ((d3 = this.useSmoothedAcceptanceProbability ? adaptableMCMCOperator.getSmoothedAcceptanceProbability() : Math.exp(d)) - (d2 = adaptableMCMCOperator.getTargetAcceptanceProbability()))) > -1.7976931348623157E308 && d6 < Double.MAX_VALUE) {
            adaptableMCMCOperator.setAdaptableParameter(d6);
        }
    }

    public void addMarkovChainListener(MarkovChainListener markovChainListener) {
        if (markovChainListener != null) {
            this.listeners.add(markovChainListener);
        }
    }

    public void removeMarkovChainListener(MarkovChainListener markovChainListener) {
        this.listeners.remove(markovChainListener);
    }

    private void fireBestModel(long l, Model model) {
        for (MarkovChainListener markovChainListener : this.listeners) {
            markovChainListener.bestState(l, this, model);
        }
    }

    private void fireCurrentModel(long l, Model model) {
        for (MarkovChainListener markovChainListener : this.listeners) {
            markovChainListener.currentState(l, this, model);
        }
    }

    private void fireFinished(long l) {
        for (MarkovChainListener markovChainListener : this.listeners) {
            markovChainListener.finished(l, this);
        }
    }

    private void fireEndCurrentIteration(long l) {
    }

    private void fillDensities(Likelihood likelihood, Map<String, Double> map) {
        if (likelihood instanceof CompoundLikelihood) {
            for (Likelihood likelihood2 : ((CompoundLikelihood)likelihood).getLikelihoods()) {
                this.fillDensities(likelihood2, map);
            }
        } else {
            double d = likelihood.getLogLikelihood();
            map.put(likelihood.prettyName(), d);
        }
    }
}

