/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.TransformedParameter;
import dr.util.Transform;

public class TransformedMultivariateParameter
extends TransformedParameter {
    private double[] transformedValues;
    private double[] unTransformedValues;

    public TransformedMultivariateParameter(Parameter parameter, Transform.MultivariableTransform multivariableTransform) {
        this(parameter, multivariableTransform, false);
    }

    public TransformedMultivariateParameter(Parameter parameter, Transform.MultivariableTransform multivariableTransform, boolean bl) {
        super(parameter, multivariableTransform, bl);
        this.unTransformedValues = parameter.getParameterValues();
        this.transformedValues = this.transform(this.unTransformedValues);
    }

    @Override
    public double getParameterValue(int n) {
        this.update();
        return this.transformedValues[n];
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.update();
        this.transformedValues[n] = d;
        this.unTransformedValues = this.inverse(this.transformedValues);
        this.parameter.setParameterValueNotifyChangedAll(0, this.unTransformedValues[0]);
        for (int i = 1; i < this.parameter.getDimension(); ++i) {
            this.parameter.setParameterValueQuietly(i, this.unTransformedValues[i]);
        }
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.update();
        this.transformedValues[n] = d;
        this.unTransformedValues = this.inverse(this.transformedValues);
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            this.parameter.setParameterValueQuietly(i, this.unTransformedValues[i]);
        }
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.setParameterValue(n, d);
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        this.transformedBounds = bounds;
    }

    private void update() {
        if (this.hasChanged()) {
            this.unTransformedValues = this.parameter.getParameterValues();
            this.transformedValues = this.transform(this.unTransformedValues);
        }
    }

    private boolean hasChanged() {
        for (int i = 0; i < this.unTransformedValues.length; ++i) {
            if (this.parameter.getParameterValue(i) == this.unTransformedValues[i]) continue;
            return true;
        }
        return false;
    }
}

