/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.IndependentInverseGammaDistributionModel;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.GammaDistribution;

public class ShrinkageAugmentedGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    Parameter localShape;
    Parameter globalShape;
    Parameter localAugmented;
    Parameter globalAugmented;
    Parameter local;
    Parameter global;
    double localAugmentedShape;
    double localAugmentedRate;
    double globalAugmentedShape;
    double globalAugmentedRate;
    double pathParameter;

    public ShrinkageAugmentedGibbsOperator(double d, DistributionLikelihood distributionLikelihood, DistributionLikelihood distributionLikelihood2, IndependentInverseGammaDistributionModel independentInverseGammaDistributionModel, IndependentInverseGammaDistributionModel independentInverseGammaDistributionModel2) {
        this.setWeight(d);
        GammaDistribution gammaDistribution = (GammaDistribution)distributionLikelihood.getDistribution();
        GammaDistribution gammaDistribution2 = (GammaDistribution)distributionLikelihood2.getDistribution();
        this.localShape = independentInverseGammaDistributionModel.getShape();
        this.globalShape = independentInverseGammaDistributionModel2.getShape();
        this.local = independentInverseGammaDistributionModel.getData();
        this.global = independentInverseGammaDistributionModel2.getData();
        this.localAugmented = independentInverseGammaDistributionModel.getScale();
        this.globalAugmented = independentInverseGammaDistributionModel2.getScale();
        this.localAugmentedShape = gammaDistribution.getShape();
        this.localAugmentedRate = 1.0 / gammaDistribution.getScale();
        this.globalAugmentedShape = gammaDistribution2.getShape();
        this.globalAugmentedRate = 1.0 / gammaDistribution2.getScale();
        this.pathParameter = 1.0;
    }

    public int getStepCount() {
        return 0;
    }

    @Override
    public String getOperatorName() {
        return "ShrinkageAugmentedGibbsOperator";
    }

    @Override
    public double doOperation() {
        for (int i = 0; i < this.local.getDimension(); ++i) {
            double d = this.localAugmentedShape + this.localShape.getParameterValue(i);
            double d2 = this.localAugmentedRate + 1.0 / this.local.getParameterValue(i);
            this.localAugmented.setParameterValueQuietly(i, GammaDistribution.nextGamma(d, 1.0 / d2));
        }
        this.localAugmented.fireParameterChangedEvent();
        double d = this.globalAugmentedShape + this.globalShape.getParameterValue(0);
        double d3 = this.globalAugmentedRate + 1.0 / this.global.getParameterValue(0);
        this.globalAugmented.setParameterValue(0, GammaDistribution.nextGamma(d, 1.0 / d3));
        return 0.0;
    }
}

