/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

public class GammaFunction {
    public static double lnGamma(double d) {
        double d2;
        double d3 = d;
        double d4 = 0.0;
        if (d3 < 7.0) {
            d4 = 1.0;
            d2 = d3 - 1.0;
            while (true) {
                double d5;
                d2 += 1.0;
                if (!(d5 < 7.0)) break;
                d4 *= d2;
            }
            d3 = d2;
            d4 = -Math.log(d4);
        }
        d2 = 1.0 / (d3 * d3);
        return d4 + (d3 - 0.5) * Math.log(d3) - d3 + 0.918938533204673 + (((-5.95238095238E-4 * d2 + 7.93650793651E-4) * d2 - 0.002777777777778) * d2 + 0.083333333333333) / d3;
    }

    public static double incompleteGammaQ(double d, double d2) {
        return 1.0 - GammaFunction.incompleteGamma(d2, d, GammaFunction.lnGamma(d));
    }

    public static double incompleteGammaP(double d, double d2) {
        return GammaFunction.incompleteGamma(d2, d, GammaFunction.lnGamma(d));
    }

    public static double incompleteGammaP(double d, double d2, double d3) {
        return GammaFunction.incompleteGamma(d2, d, d3);
    }

    private static double incompleteGamma(double d, double d2, double d3) {
        double d4;
        double d5 = 1.0E-8;
        double d6 = 1.0E30;
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Arguments out of bounds");
        }
        double d7 = Math.exp(d2 * Math.log(d) - d - d3);
        if (d > 1.0 && d >= d2) {
            double d8 = 1.0 - d2;
            double d9 = d8 + d + 1.0;
            double d10 = 0.0;
            double d11 = 1.0;
            double d12 = d;
            double d13 = d + 1.0;
            double d14 = d * d9;
            d4 = d13 / d14;
            while (true) {
                double d15 = (d8 += 1.0) * (d10 += 1.0);
                double d16 = (d9 += 2.0) * d13 - d15 * d11;
                double d17 = d9 * d14 - d15 * d12;
                if (d17 != 0.0) {
                    double d18 = d16 / d17;
                    double d19 = Math.abs(d4 - d18);
                    if (d19 <= d5 && d19 <= d5 * d18) break;
                    d4 = d18;
                }
                d11 = d13;
                d12 = d14;
                d13 = d16;
                d14 = d17;
                if (!(Math.abs(d16) >= d6)) continue;
                d11 /= d6;
                d12 /= d6;
                d13 /= d6;
                d14 /= d6;
            }
            d4 = 1.0 - d7 * d4;
        } else {
            d4 = 1.0;
            double d20 = 1.0;
            double d21 = d2;
            do {
                d4 += (d20 *= d / (d21 += 1.0));
            } while (d20 > d5);
            d4 *= d7 / d2;
        }
        return d4;
    }
}

