/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.treelikelihood.AbstractTreeLikelihood;
import dr.oldevomodel.treelikelihood.AminoAcidLikelihoodCore;
import dr.oldevomodel.treelikelihood.GeneralLikelihoodCore;
import dr.oldevomodel.treelikelihood.LikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeNucleotideLikelihoodCore;
import dr.oldevomodel.treelikelihood.NucleotideLikelihoodCore;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public class PurifyingTreeLikelihood
extends AbstractTreeLikelihood {
    public static final String PURIFYING_TREE_LIKELIHOOD = "purifyingTreeLikelihood";
    public static final String HALF_LIFE = "halfLife";
    public static final String PROPORTION = "proportion";
    public static final String AVERAGE = "average";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("average", false), new ElementRule("proportion", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("halfLife", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(PatternList.class), new ElementRule(TreeModel.class), new ElementRule(SiteModel.class)};

        @Override
        public String getParserName() {
            return PurifyingTreeLikelihood.PURIFYING_TREE_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(PurifyingTreeLikelihood.PROPORTION);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(PurifyingTreeLikelihood.HALF_LIFE);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            SiteModel siteModel = (SiteModel)xMLObject.getChild(SiteModel.class);
            boolean bl = xMLObject.getBooleanAttribute(PurifyingTreeLikelihood.AVERAGE);
            try {
                return new PurifyingTreeLikelihood(patternList, treeModel, siteModel, parameter, parameter2, false, bl);
            }
            catch (TaxonList.MissingTaxonException missingTaxonException) {
                throw new XMLParseException(missingTaxonException.toString());
            }
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of a patternlist on a tree given the site model.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    protected FrequencyModel frequencyModel = null;
    protected SiteModel siteModel = null;
    protected Parameter proportionParameter = null;
    protected Parameter lambdaParameter = null;
    private boolean updateRates = false;
    private double[] nodeTimes = null;
    private boolean useAveraging = true;
    private boolean integrateAcrossCategories = false;
    protected double[] branchRates = null;
    protected int[] siteCategories = null;
    protected double[] rootPartials = null;
    protected double[] patternLogLikelihoods = null;
    protected int categoryCount;
    protected double[] probabilities;
    protected LikelihoodCore likelihoodCore;

    public PurifyingTreeLikelihood(PatternList patternList, TreeModel treeModel, SiteModel siteModel, Parameter parameter, Parameter parameter2, boolean bl, boolean bl2) throws TaxonList.MissingTaxonException {
        super(PURIFYING_TREE_LIKELIHOOD, patternList, treeModel);
        this.useAveraging = bl2;
        try {
            int n;
            this.siteModel = siteModel;
            this.addModel(siteModel);
            this.frequencyModel = siteModel.getFrequencyModel();
            this.addModel(this.frequencyModel);
            this.proportionParameter = parameter;
            this.addVariable(parameter);
            this.lambdaParameter = parameter2;
            this.addVariable(parameter2);
            this.integrateAcrossCategories = siteModel.integrateAcrossCategories();
            this.categoryCount = siteModel.getCategoryCount();
            if (this.integrateAcrossCategories) {
                if (patternList.getDataType() instanceof Nucleotides) {
                    if (NativeNucleotideLikelihoodCore.isAvailable()) {
                        System.out.println("TreeLikelihood using native nucleotide likelihood core.");
                        this.likelihoodCore = new NativeNucleotideLikelihoodCore();
                    } else {
                        System.out.println("TreeLikelihood using Java nucleotide likelihood core.");
                        this.likelihoodCore = new NucleotideLikelihoodCore();
                    }
                } else if (patternList.getDataType() instanceof AminoAcids) {
                    System.out.println("TreeLikelihood using Java amino acid likelihood core.");
                    this.likelihoodCore = new AminoAcidLikelihoodCore();
                } else {
                    System.out.println("TreeLikelihood using Java general likelihood core.");
                    this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
                }
            } else {
                System.out.println("TreeLikelihood using Java general likelihood core.");
                this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
            }
            this.probabilities = new double[this.stateCount * this.stateCount];
            this.likelihoodCore.initialize(this.nodeCount, this.patternCount, this.categoryCount, this.integrateAcrossCategories);
            int n2 = treeModel.getExternalNodeCount();
            int n3 = treeModel.getInternalNodeCount();
            for (n = 0; n < n2; ++n) {
                String string = treeModel.getTaxonId(n);
                int n4 = patternList.getTaxonIndex(string);
                if (n4 == -1) {
                    throw new TaxonList.MissingTaxonException("Taxon, " + string + ", in tree, " + treeModel.getId() + ", is not found in patternList, " + patternList.getId());
                }
                if (bl) {
                    this.setPartials(this.likelihoodCore, patternList, this.categoryCount, n4, n);
                    continue;
                }
                this.setStates(this.likelihoodCore, patternList, n4, n);
            }
            for (n = 0; n < n3; ++n) {
                this.likelihoodCore.createNodePartials(n2 + n);
            }
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                if (((TreeChangedEvent)object).isNodeChanged()) {
                    this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                } else {
                    this.updateAllNodes();
                }
            }
            this.updateRates = true;
        } else if (model == this.frequencyModel) {
            this.updateAllNodes();
        } else if (model instanceof SiteModel) {
            this.updateAllNodes();
        } else {
            throw new RuntimeException("Unknown componentChangedEvent");
        }
        super.handleModelChangedEvent(model, object, n);
    }

    public void handleParameterChangedEvent(Parameter parameter, int n) {
        if (parameter == this.proportionParameter || parameter == this.lambdaParameter) {
            this.updateRates = true;
            this.updateAllNodes();
        }
    }

    @Override
    protected void storeState() {
        this.likelihoodCore.storeState();
        super.storeState();
    }

    @Override
    protected void restoreState() {
        this.likelihoodCore.restoreState();
        super.restoreState();
    }

    @Override
    protected double calculateLogLikelihood() {
        NodeRef nodeRef = this.treeModel.getRoot();
        if (this.rootPartials == null) {
            this.rootPartials = new double[this.patternCount * this.stateCount];
        }
        if (this.patternLogLikelihoods == null) {
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        if (!this.integrateAcrossCategories) {
            if (this.siteCategories == null) {
                this.siteCategories = new int[this.patternCount];
            }
            for (int i = 0; i < this.patternCount; ++i) {
                this.siteCategories[i] = this.siteModel.getCategoryOfSite(i);
            }
        }
        double d = this.proportionParameter.getParameterValue(0);
        double d2 = Math.log(2.0) / this.lambdaParameter.getParameterValue(0);
        this.updateRates = true;
        this.updateAllNodes();
        if (this.updateRates) {
            if (this.nodeTimes == null) {
                this.nodeTimes = new double[this.treeModel.getNodeCount()];
            }
            this.calculateNodeRates(this.treeModel, nodeRef, 1.0, d, d2);
        }
        this.traverse(this.treeModel, nodeRef);
        this.updateRates = false;
        for (int i = 0; i < this.nodeCount; ++i) {
            this.updateNode[i] = false;
        }
        double d3 = 0.0;
        for (int i = 0; i < this.patternCount; ++i) {
            d3 += this.patternLogLikelihoods[i] * this.patternWeights[i];
        }
        if (Double.isNaN(d3)) {
            throw new RuntimeException("Likelihood NaN");
        }
        return d3;
    }

    private double calculateNodeRates(TreeModel treeModel, NodeRef nodeRef, double d, double d2, double d3) {
        double d4;
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        double d5 = 0.0;
        if (!treeModel.isExternal(nodeRef)) {
            NodeRef nodeRef3 = treeModel.getChild(nodeRef, 0);
            double d6 = this.calculateNodeRates(treeModel, nodeRef3, d, d2, d3);
            NodeRef nodeRef4 = treeModel.getChild(nodeRef, 1);
            d4 = this.calculateNodeRates(treeModel, nodeRef4, d, d2, d3);
            d5 = this.useAveraging ? (d6 + d4) / 2.0 : (d6 > d4 ? d6 : d4);
        }
        if (nodeRef2 == null) {
            return 0.0;
        }
        double d7 = treeModel.getNodeHeight(nodeRef2) - treeModel.getNodeHeight(nodeRef);
        double d8 = d5 + d7;
        d4 = this.rateIntegral(d8, d, d2, d3);
        if (d5 > 0.0) {
            d4 -= this.rateIntegral(d5, d, d2, d3);
        }
        if (d4 != treeModel.getNodeRate(nodeRef)) {
            this.updateNode(nodeRef);
            this.nodeTimes[nodeRef.getNumber()] = d4;
        }
        return d8;
    }

    private double rateIntegral(double d, double d2, double d3, double d4) {
        return d2 * (d3 * d - (1.0 - d3) / d4 * (Math.exp(-d4 * d) - 1.0));
    }

    private boolean traverse(Tree tree, NodeRef nodeRef) {
        boolean bl = false;
        int n = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 != null && this.updateNode[n]) {
            double d = this.nodeTimes[nodeRef.getNumber()];
            for (int i = 0; i < this.categoryCount; ++i) {
                double d2 = this.siteModel.getRateForCategory(i) * d;
                this.siteModel.getSubstitutionModel().getTransitionProbabilities(d2, this.probabilities);
                this.likelihoodCore.setNodeMatrix(n, i, this.probabilities);
            }
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traverse(tree, nodeRef3);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            boolean bl3 = this.traverse(tree, nodeRef4);
            if (bl2 || bl3) {
                int n2 = nodeRef3.getNumber();
                int n3 = nodeRef4.getNumber();
                if (this.integrateAcrossCategories) {
                    this.likelihoodCore.calculatePartials(n2, n3, n);
                } else {
                    this.likelihoodCore.calculatePartials(n2, n3, n, this.siteCategories);
                }
                if (nodeRef2 == null) {
                    double[] dArray = this.frequencyModel.getFrequencies();
                    if (this.integrateAcrossCategories) {
                        double[] dArray2 = this.siteModel.getCategoryProportions();
                        this.likelihoodCore.integratePartials(n, dArray2, this.rootPartials);
                    } else {
                        this.likelihoodCore.getPartials(n, this.rootPartials);
                    }
                    this.likelihoodCore.calculateLogLikelihoods(this.rootPartials, dArray, this.patternLogLikelihoods);
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("createElement not implemented");
    }
}

