/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ClusteringTreeBuilder;
import jebl.evolution.trees.ConsensusTreeBuilder;
import jebl.evolution.trees.GreedyRootedConsensusTreeBuilder;
import jebl.evolution.trees.GreedyUnrootedConsensusTreeBuilder;
import jebl.evolution.trees.MRCACConsensusTreeBuilder;
import jebl.evolution.trees.NeighborJoiningTreeBuilder;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.UPGMATreeBuilder;

public class TreeBuilderFactory {
    public static boolean isRootedMethod(Method method) {
        switch (method) {
            case UPGMA: {
                return true;
            }
        }
        return false;
    }

    public static ClusteringTreeBuilder getBuilder(Method method, DistanceMatrix distances) {
        ClusteringTreeBuilder builder;
        switch (method) {
            case UPGMA: {
                builder = new UPGMATreeBuilder(distances);
                break;
            }
            default: {
                builder = new NeighborJoiningTreeBuilder(distances);
            }
        }
        return builder;
    }

    public static ConsensusTreeBuilder buildUnRooted(Tree[] trees, Taxon outGroup, double supportThreshold, ConsensusMethod method) {
        if (!(supportThreshold >= 0.0) || !(supportThreshold <= 1.0)) {
            throw new IllegalArgumentException("support not in [0..1]: " + supportThreshold);
        }
        switch (method) {
            case GREEDY: {
                return new GreedyUnrootedConsensusTreeBuilder(trees, outGroup, supportThreshold);
            }
        }
        throw new IllegalArgumentException(method.toString());
    }

    public static ConsensusTreeBuilder buildRooted(RootedTree[] trees, double supportThreshold, ConsensusMethod method) {
        if (!(supportThreshold >= 0.0) || !(supportThreshold <= 1.0)) {
            throw new IllegalArgumentException("Expected support value in [0..1], got " + String.format("%.3f", supportThreshold));
        }
        switch (method) {
            case GREEDY: {
                return new GreedyRootedConsensusTreeBuilder(trees, supportThreshold);
            }
            case MRCAC: {
                return new MRCACConsensusTreeBuilder(trees, supportThreshold);
            }
        }
        throw new IllegalArgumentException("Unknown consensus method: " + (Object)((Object)method));
    }

    public static ConsensusTreeBuilder buildRooted(Tree[] trees, double supportThreshold, ConsensusMethod method) {
        RootedTree[] rtrees = new RootedTree[trees.length];
        for (int i = 0; i < trees.length; ++i) {
            rtrees[i] = (RootedTree)trees[i];
        }
        return TreeBuilderFactory.buildRooted(rtrees, supportThreshold, method);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConsensusMethod {
        GREEDY,
        MRCAC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistanceModel {
        JukesCantor,
        F84,
        HKY,
        TamuraNei;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        NEIGHBOR_JOINING("Neighbor-Joining"),
        UPGMA("UPGMA");

        private String name;

        private Method(String name) {
            this.name = name;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.name;
        }
    }
}

