/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneticCode;
import dr.evolution.datatype.Nucleotides;

public class SimpleCodons
extends DataType {
    public static final String DESCRIPTION = "simpleCodon";
    public static final int TYPE = 2;
    public static final SimpleCodons UNIVERSAL = new SimpleCodons(GeneticCode.UNIVERSAL);
    public static final SimpleCodons VERTEBRATE_MT = new SimpleCodons(GeneticCode.VERTEBRATE_MT);
    public static final SimpleCodons YEAST = new SimpleCodons(GeneticCode.YEAST);
    public static final SimpleCodons MOLD_PROTOZOAN_MT = new SimpleCodons(GeneticCode.MOLD_PROTOZOAN_MT);
    public static final SimpleCodons MYCOPLASMA = new SimpleCodons(GeneticCode.MYCOPLASMA);
    public static final SimpleCodons INVERTEBRATE_MT = new SimpleCodons(GeneticCode.INVERTEBRATE_MT);
    public static final SimpleCodons CILIATE = new SimpleCodons(GeneticCode.CILIATE);
    public static final SimpleCodons ECHINODERM_MT = new SimpleCodons(GeneticCode.ECHINODERM_MT);
    public static final SimpleCodons EUPLOTID_NUC = new SimpleCodons(GeneticCode.EUPLOTID_NUC);
    public static final SimpleCodons BACTERIAL = new SimpleCodons(GeneticCode.BACTERIAL);
    public static final SimpleCodons ALT_YEAST = new SimpleCodons(GeneticCode.ALT_YEAST);
    public static final SimpleCodons ASCIDIAN_MT = new SimpleCodons(GeneticCode.ASCIDIAN_MT);
    public static final SimpleCodons FLATWORM_MT = new SimpleCodons(GeneticCode.FLATWORM_MT);
    public static final SimpleCodons BLEPHARISMA_NUC = new SimpleCodons(GeneticCode.BLEPHARISMA_NUC);
    public static final int UNKNOWN_STATE = 64;
    public static final int GAP_STATE = 65;
    public static final String[] CODON_TRIPLETS = new String[]{"AAA", "AAC", "AAG", "AAT", "ACA", "ACC", "ACG", "ACT", "AGA", "AGC", "AGG", "AGT", "ATA", "ATC", "ATG", "ATT", "CAA", "CAC", "CAG", "CAT", "CCA", "CCC", "CCG", "CCT", "CGA", "CGC", "CGG", "CGT", "CTA", "CTC", "CTG", "CTT", "GAA", "GAC", "GAG", "GAT", "GCA", "GCC", "GCG", "GCT", "GGA", "GGC", "GGG", "GGT", "GTA", "GTC", "GTG", "GTT", "TAA", "TAC", "TAG", "TAT", "TCA", "TCC", "TCG", "TCT", "TGA", "TGC", "TGG", "TGT", "TTA", "TTC", "TTG", "TTT", "???", "---"};
    private GeneticCode geneticCode;

    private SimpleCodons(GeneticCode geneticCode) {
        this.geneticCode = geneticCode;
        this.stateCount = 64;
        this.ambiguousStateCount = 66;
    }

    @Override
    public char[] getValidChars() {
        return null;
    }

    @Override
    public final int getState(char c) {
        throw new IllegalArgumentException("Codons datatype cannot be expressed as char");
    }

    @Override
    public int getUnknownState() {
        return 64;
    }

    @Override
    public int getGapState() {
        return 65;
    }

    public final int getState(char c, char c2, char c3) {
        return this.getState(Nucleotides.INSTANCE.getState(c), Nucleotides.INSTANCE.getState(c2), Nucleotides.INSTANCE.getState(c3));
    }

    public final int getState(int n, int n2, int n3) {
        if (Nucleotides.INSTANCE.isGapState(n) || Nucleotides.INSTANCE.isGapState(n2) || Nucleotides.INSTANCE.isGapState(n3)) {
            return 65;
        }
        if (Nucleotides.INSTANCE.isAmbiguousState(n) || Nucleotides.INSTANCE.isAmbiguousState(n2) || Nucleotides.INSTANCE.isAmbiguousState(n3)) {
            return 64;
        }
        return n * 16 + n2 * 4 + n3;
    }

    @Override
    public final char getChar(int n) {
        throw new IllegalArgumentException("Codons datatype cannot be expressed as char");
    }

    @Override
    public final String getTriplet(int n) {
        return CODON_TRIPLETS[n];
    }

    public final int[] getTripletStates(int n) {
        int[] nArray = new int[]{Nucleotides.INSTANCE.getState(CODON_TRIPLETS[n].charAt(0)), Nucleotides.INSTANCE.getState(CODON_TRIPLETS[n].charAt(1)), Nucleotides.INSTANCE.getState(CODON_TRIPLETS[n].charAt(2))};
        return nArray;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 2;
    }

    public GeneticCode getGeneticCode() {
        return this.geneticCode;
    }

    public final boolean isStopCodon(int n) {
        return this.geneticCode.isStopCodon(n);
    }
}

