/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class CheckOptionHandler {
    public static String printOptions(String[] stringArray) {
        if (stringArray == null) {
            return "<null>";
        }
        return Utils.joinOptions(stringArray);
    }

    public static void compareOptions(String[] stringArray, String[] stringArray2) throws Exception {
        if (stringArray == null) {
            throw new Exception("first set of options is null!");
        }
        if (stringArray2 == null) {
            throw new Exception("second set of options is null!");
        }
        if (stringArray.length != stringArray2.length) {
            throw new Exception("problem found!\nFirst set: " + CheckOptionHandler.printOptions(stringArray) + '\n' + "Second set: " + CheckOptionHandler.printOptions(stringArray2) + '\n' + "options differ in length");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            throw new Exception("problem found!\n\tFirst set: " + CheckOptionHandler.printOptions(stringArray) + '\n' + "\tSecond set: " + CheckOptionHandler.printOptions(stringArray2) + '\n' + '\t' + stringArray[i] + " != " + stringArray2[i]);
        }
    }

    public static void checkOptionHandler(OptionHandler optionHandler, String[] stringArray) throws Exception {
        Object object;
        System.out.println("OptionHandler: " + optionHandler.getClass().getName());
        System.out.println("ListOptions:");
        Enumeration enumeration = optionHandler.listOptions();
        while (enumeration.hasMoreElements()) {
            object = (Option)enumeration.nextElement();
            System.out.println(((Option)object).synopsis());
            System.out.println(((Option)object).description());
        }
        object = optionHandler.getOptions();
        System.out.print("Default options:");
        System.out.println(CheckOptionHandler.printOptions((String[])object));
        System.out.print("User options:");
        System.out.println(CheckOptionHandler.printOptions(stringArray));
        System.out.println("Setting user options...");
        optionHandler.setOptions(stringArray);
        System.out.print("Remaining options:");
        System.out.println(CheckOptionHandler.printOptions(stringArray));
        System.out.print("Getting canonical user options:");
        String[] stringArray2 = optionHandler.getOptions();
        System.out.println(CheckOptionHandler.printOptions(stringArray2));
        System.out.println("Setting canonical user options...");
        optionHandler.setOptions((String[])stringArray2.clone());
        System.out.print("Checking canonical user options...");
        String[] stringArray3 = optionHandler.getOptions();
        CheckOptionHandler.compareOptions(stringArray2, stringArray3);
        System.out.println("OK");
        System.out.println("Resetting to default options...");
        optionHandler.setOptions((String[])object.clone());
        System.out.print("Checking default options match previous default...");
        String[] stringArray4 = optionHandler.getOptions();
        CheckOptionHandler.compareOptions((String[])object, stringArray4);
        System.out.println("OK");
    }

    public static void main(String[] stringArray) {
        try {
            OptionHandler optionHandler;
            String string = Utils.getOption('W', stringArray);
            if (string.length() == 0) {
                throw new Exception("Please give a class name with -W option");
            }
            try {
                optionHandler = (OptionHandler)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new Exception("Couldn't find OptionHandler with name " + string);
            }
            String[] stringArray2 = Utils.partitionOptions(stringArray);
            Utils.checkForRemainingOptions(stringArray);
            CheckOptionHandler.checkOptionHandler(optionHandler, stringArray2);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

