% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R
\name{dag.threshold}
\alias{dag.threshold}
\title{Estimating a graph corresponding to a posterior probability threshold}
\usage{
dag.threshold(n, MCMCchain, pbarrier, pdag = FALSE, burnin = 0.2)
}
\arguments{
\item{n}{number of nodes in the Bayesian network}

\item{MCMCchain}{list of adjacency matrices with dimensions equal to n and elements in \code{\{0,1\}}, representing a sample of DAGs from an MCMC scheme}

\item{pbarrier}{threshold such that only edges with a higher posterior probability will be retained in the directed graph summarising the sample of DAGs}

\item{pdag}{logical, if TRUE (FALSE by default) all DAGs in the MCMCchain are first converted to equivalence class (CPDAG) before the averaging}

\item{burnin}{(optional)  number between \code{0} and \code{1}, indicates the percentage of the samples which will be  the discarded as `burn-in' of the MCMC chain; the rest  of the samples will be used to calculate the posterior probabilities; 0.2 by default}
}
\value{
a square matrix with dimensions equal to the number of variables representing the adjacency matrix of the directed graph summarising the sample of DAGs
}
\description{
This function constructs a directed graph (not necessarily acyclic) including all edges with a posterior probability above a certain threshold.  The posterior probability is evaluated as the Monte Carlo estimate from a sample of DAGs obtained via an MCMC scheme.
}
\examples{
Bostonscore<-scoreparameters(14, "bge", Boston)
\dontrun{
orderfit<-orderMCMC(14, Bostonscore, MAP=FALSE, iterations=25000)
MCMCchain<-orderfit$chain$incidence
hdag<-dag.threshold(14, MCMCchain, pbarrier=0.9)
}
}
