% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R
\name{sample.check}
\alias{sample.check}
\title{Performance assessment of sampling algorithms against a known Bayesian network}
\usage{
sample.check(n, MCMCchain, truedag, pbarrier = c(0.99, 0.95, 0.9, 0.8, 0.7,
  0.6, 0.5, 0.4, 0.3, 0.2), pdag = TRUE, burnin = 0.2)
}
\arguments{
\item{n}{number of nodes in the Bayesian network}

\item{MCMCchain}{list of adjacency matrices with dimensions equal to n and elements in \code{\{0,1\}}, representing a sample of DAGs from an MCMC scheme}

\item{truedag}{ground truth DAG which generated the data used in the search procedure; represented by an object of class  \code{\link[graph]{graphNEL}}}

\item{pbarrier}{(optional) a vector of numeric values between 0 and 1, defining posterior probabilities according to which the edges of assessed structures are drawn, please note very low barriers can lead to very dense structures; by default 
\eqn{pbarrier=c(0.99, 0.95, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2)}}

\item{pdag}{logical, if TRUE (default) all DAGs in the MCMCchain are first converted to equivalence class (CPDAG) before the averaging}

\item{burnin}{(optional)  number between \code{0} and \code{1}, indicates the percentage of the samples which will be  the discarded as `burn-in' of the MCMC chain; the rest  of the samples will be used to calculate the posterior probabilities; 0.2 by default}
}
\value{
A matrix with the number of rows equal to the number of posterior thresholds tested, and 4 columns reporting for each  thresholded directed graphs the number of true positive edges (`TP'), the number of false positive edges (`FP'), the structural Hamming distance (`SHD') and the posterior threshold
}
\description{
This function calculates the number of true and false positives and the structural Hamming distance between a ground truth DAG and a directed graph summarising a sample of DAGs obtained from an MCMC scheme, as the posterior probability threshold is varied
}
\examples{
myDAG<-pcalg::randomDAG(n=20, prob=0.1, lB = 0.4, uB = 2)
myData<-pcalg::rmvDAG(200,myDAG)
myScore<-scoreparameters(20, "bge", myData)
\dontrun{
ordersample<-orderMCMC(n=20, myScore, chainout=TRUE)
MCMCchain<-ordersample$chain$incidence
sample.check(n=20, MCMCchain, myDAG, pdag=TRUE, burnin=0.2)
}
}
