% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotusingrgraphviz.R
\name{plotdiffs.DBN}
\alias{plotdiffs.DBN}
\title{Plotting difference between two DBNs}
\usage{
plotdiffs.DBN(
  eDBN,
  trueDBN,
  struct = c("init", "trans"),
  n.dynamic,
  n.static = 0
)
}
\arguments{
\item{eDBN}{object of class graphNEL (or its adjacency matrix), representing estimated structure (not necessarily acyclic) to be compared to the ground truth graph}

\item{trueDBN}{object of class graphNEL (or its adjacency matrix), representing the ground truth structure (not necessarily acyclic)}

\item{struct}{option used to determine if the initial or the transition structure should be plotted; accaptable values are init or trans}

\item{n.dynamic}{number of dynamic variables in one time slice of a DBN}

\item{n.static}{number of static variables in one time slice of a DBN; note that for function to work correctly all static variables have to be in the first n.static columns of the matrix}
}
\value{
plots the graph which includes edges from edag and truedag, however edges which are different in edag compared to truedag are coloured according to the type of a mistake: false positive with red, false negative with dashed grey, error in direction with magenta
}
\description{
This function plots an estimated DBN such that the edges which are different to the ground truth DBN are highlighted.
}
\examples{
dbnscore<-scoreparameters(15,"bge",DBNdata,
dbnpar = list(samestruct=TRUE, slices=5, stationary=TRUE),
DBN=TRUE,bgnodes=c(1,2,3))
\dontrun{
orderDBNfit<-iterativeMCMC(dbnscore,chainout = TRUE, mergetype = "skeleton",scoreout=TRUE,alpha=0.4)
plotdiffs.DBN(orderDBNfit$max$DAG,DBNmat,struct="trans",n.dynamic=12,n.static=3)
plotdiffs.DBN(orderDBNfit$max$DAG,DBNmat,struct="init",n.dynamic=12,n.static=3)
}
}
