% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.venn.R
\name{draw.venn}
\alias{draw.venn}
\title{Draw an area-proportional Venn diagram of 2 or 3 circles}
\usage{
draw.venn(
  list_x,
  list_y,
  list_z,
  title = "BioVenn",
  t_f = "serif",
  t_fb = 2,
  t_s = 1.5,
  t_c = "black",
  subtitle = "(C) 2007-2020 Tim Hulsen",
  st_f = "serif",
  st_fb = 2,
  st_s = 1.2,
  st_c = "black",
  xtitle = "ID Set X",
  xt_f = "serif",
  xt_fb = 2,
  xt_s = 1,
  xt_c = "black",
  ytitle = "ID Set Y",
  yt_f = "serif",
  yt_fb = 2,
  yt_s = 1,
  yt_c = "black",
  ztitle = "ID Set Z",
  zt_f = "serif",
  zt_fb = 2,
  zt_s = 1,
  zt_c = "black",
  nrtype = "abs",
  nr_f = "serif",
  nr_fb = 2,
  nr_s = 1,
  nr_c = "black",
  x_c = "red",
  y_c = "green",
  z_c = "blue",
  bg_c = "white",
  width = 1000,
  height = 1000,
  output = "screen",
  filename = NULL,
  map2ens = FALSE
)
}
\arguments{
\item{list_x}{(Required) List with IDs from dataset X}

\item{list_y}{(Required) List with IDs from dataset Y}

\item{list_z}{(Required) List with IDs from dataset Z}

\item{title}{(Optional) The title of the Venn diagram (default is "BioVenn")}

\item{t_f}{(Optional) The font of the main title (default is "serif")}

\item{t_fb}{(Optional) The font "face" of the main title (1=plain, 2=bold, 3=italic, 4=bold-italic; default is 2)}

\item{t_s}{(Optional) The size of the main title (cex; relative to the standard size; default is 1.5)}

\item{t_c}{(Optional) The colour of the main title (default is "black")}

\item{subtitle}{(Optional) The subtitle of the Venn diagram (default is "(C) 2007-2020 Tim Hulsen")}

\item{st_f}{(Optional) The font of the subtitle (default is "serif")}

\item{st_fb}{(Optional) The font "face" of the subtitle (1=plain, 2=bold, 3=italic, 4=bold-italic; default is 2)}

\item{st_s}{(Optional) The size of the subtitle (cex; relative to the standard size; default is 1.2)}

\item{st_c}{(Optional) The colour of the subtitle (default is "black")}

\item{xtitle}{(Optional) The X title of the Venn diagram (default is "ID set X")}

\item{xt_f}{(Optional) The font of the X title (default is "serif")}

\item{xt_fb}{(Optional) The font "face" of the X title (1=plain, 2=bold, 3=italic, 4=bold-italic; default is 2)}

\item{xt_s}{(Optional) The size of the X title (cex; relative to the standard size; default is 1)}

\item{xt_c}{(Optional) The colour of the X title (default is "black")}

\item{ytitle}{(Optional) The Y title of the Venn diagram (default is "ID set Y")}

\item{yt_f}{(Optional) The font of the Y title (default is "serif")}

\item{yt_fb}{(Optional) The font "face" of the Y title (1=plain, 2=bold, 3=italic, 4=bold-italic; default is 2)}

\item{yt_s}{(Optional) The size of the Y title (cex; relative to the standard size; default is 1)}

\item{yt_c}{(Optional) The colour of the Y title (default is "black")}

\item{ztitle}{(Optional) The Z title of the Venn diagram (default is "ID set Z")}

\item{zt_f}{(Optional) The font of the Z title (default is "serif")}

\item{zt_fb}{(Optional) The font "face" of the Z title (1=plain, 2=bold, 3=italic, 4=bold-italic; default is 2)}

\item{zt_s}{(Optional) The size of the Z title (cex; relative to the standard size; default is 1)}

\item{zt_c}{(Optional) The colour of the Z title (default is "black")}

\item{nrtype}{(Optional) The type of the numbers to be displayed: absolute (abs) numbers or percentages (pct) (default is "abs")}

\item{nr_f}{(Optional) The font of the numbers (default is "serif")}

\item{nr_fb}{(Optional) The font "face" of the numbers (1=plain, 2=bold, 3=italic, 4=bold-italic; default is 2)}

\item{nr_s}{(Optional) The size of the numbers (cex; relative to the standard size; default is 1)}

\item{nr_c}{(Optional) The colour of the numbers (default is "black")}

\item{x_c}{(Optional) The colour of the X circle (default is "red")}

\item{y_c}{(Optional) The colour of the X circle (default is "green")}

\item{z_c}{(Optional) The colour of the X circle (default is "blue")}

\item{bg_c}{(Optional) The background colour (default is "white")}

\item{width}{(Optional) The width of the output file (in pixels for BMP/JPEG/PNG/TIF or in centiinch for PDF/SVG; default is 1000)}

\item{height}{(Optional) The height of the output file (in pixels for BMP/JPEG/PNG/TIF or in centiinch for PDF/SVG; default is 1000)}

\item{output}{(Optional) Output format: "bmp","jpg","pdf","png","svg" or "tif" (anything else writes to the screen; default is "screen")}

\item{filename}{(Optional) The name of the output file (default is "biovenn" + extension of the selected output format)}

\item{map2ens}{(Optional) Map from Entrez or Affymetrix IDs to Ensembl IDs (default is FALSE)}
}
\value{
An image of the Venn diagram is generated in the desired output format.

Also returns an object with thirteen lists: X, Y, Z, X only, Y only, Z only, XY, XZ, YZ, XY only, XZ only, YZ only, XYZ.
}
\description{
This function creates an area-proportional Venn diagram of 2 or 3 circles, based on lists of (biological) identifiers.
It requires three parameters: input lists X, Y and Z. For a 2-circle Venn diagram, one of these lists
should be left empty. Duplicate identifiers are removed automatically, and a mapping from Entrez and/or
Affymetrix to Ensembl IDs is available. BioVenn is case-sensitive. In SVG mode, text and numbers can be dragged and dropped.
}
\details{
When using a BioVenn diagram for a publication, please cite:
BioVenn - an R and Python package for the comparison and visualization of biological lists using area-proportional Venn diagrams
T. Hulsen, Data Science 2021, 1-11
}
\examples{
list_x <- c("1007_s_at","1053_at","117_at","121_at","1255_g_at","1294_at")
list_y <- c("1255_g_at","1294_at","1316_at","1320_at","1405_i_at")
list_z <- c("1007_s_at","1405_i_at","1255_g_at","1431_at","1438_at","1487_at","1494_f_at")
biovenn <- draw.venn(list_x, list_y, list_z, subtitle="Example diagram", nrtype="abs")
}
