% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_mcmcglmm.R
\name{nice_mcmcglmm}
\alias{nice_mcmcglmm}
\title{Nice table of model output from MCMCglmm::MCMCglmm()}
\usage{
nice_mcmcglmm(mcmcglmm_object, dataset)
}
\arguments{
\item{mcmcglmm_object}{returned output from MCMCglmm()}

\item{dataset}{dataframe containing data}
}
\value{
grouped_df
}
\description{
Nice table of model output from MCMCglmm::MCMCglmm()
}
\examples{
\dontrun{
data(ae)

ae$AE_SEV_GD <- as.numeric(ae$AE_SEV_GD);
ae$Drug_1_Attribution <- "No";
ae$Drug_1_Attribution[ae$CTC_AE_ATTR_SCALE \%in\% c("Definite", "Probable", "Possible")] <- "Yes";
ae$Drug_1_Attribution <- as.factor(ae$Drug_1_Attribution);
ae$Drug_2_Attribution <- "No";
ae$Drug_2_Attribution[ae$CTC_AE_ATTR_SCALE_1 \%in\% c("Definite", "Probable", "Possible")] <- "Yes";
ae$Drug_2_Attribution <- as.factor(ae$Drug_2_Attribution);

prior2RE <- list(R = list(V = diag(1), fix = 1), G=list(G1=list(V=1, nu=0.02), 
          G2=list(V=1, nu=0.02)));

model1 <- MCMCglmm::MCMCglmm(Drug_1_Attribution ~ AE_SEV_GD + Drug_2_Attribution, 
          random=~ae_detail + Subject, family="categorical", data=ae, saveX=TRUE, 
          verbose=FALSE, burnin=2000, nitt=10000, thin=10, pr=TRUE, prior=prior2RE);

mcmcglmm_mva <- nice_mcmcglmm(model1, ae);
}
}
\keyword{dataframe}
