\name{BlossomPkg-package}
\alias{BlossomPkg-package}
\docType{package}
\title{
Statistical comparisons with distance-function based permutation tests
and for testing parameters estimated in linear models with permutation procedures
}
\description{
Routines include a permutation version of ordinary least squares
(OLS) regression that parallels the least absolute deviation (LAD) regression permutation test;
a permutation and asymptotic chi-square approximation of P-values for a rank score statistic
for regression quantiles; empirical coverage tests for univariate goodness-of-fit and g-sample
comparisons that are extensions of the Kolmogorov-Smirnov family of statistics for comparing cumulative
distribution functions; computing exact probabilities by complete enumeration of all possible
combinations for small block and treatment designs in multiresponse randomized block permutation procedures (MRBP);
a Monte Carlo resampling approximation alternative for all the MRPP family of statistics; and multivariate medians and distance
quantiles (MEDQ) to be used as descriptive statistics with MRPP analyses; double permutation hypothesis tests
procedures for linear model tests (OLS, LAD regression, and quantile rank score tests)
when null models are either implicitly or explicitly constrained through the origin, i.e.,
no intercept models (Cade 2003, Cade et al. 2005, Cade et al. 2006); dropping all but a single zero residual in LAD
(and quantile) regression permutation tests of subsets of variables in multiple regression models (Cade 2005, Cade and Richards 2006);
and computation of all quantile regression estimates.
}

\author{
Marian Talbert <mtalbert@usgs.gov>, Brian Cade <cadeb@usgs.gov>, Jon Richards
}
\references{
Cade, B.S. and B.R. Noon. 2003. A gentle introduction to quantile regression for ecologists. \emph{Frontiers in Ecology and the Environment} \bold{1}, 412--420.

Cade, B.S. and J.D. Richards. 2006. A permutation test for quantile regression.  \emph{Journal of Agricultural, Biological, and Environmental Statistics} \bold{11},106--126.

Cade, B.S. B.R. Noon, and C.H. Flather. 2005. Quantile regression reveals hidden bias and uncertainty in habitat models. \emph{Ecology}: \bold{86}, 786--800.

Cade, B.S., J.D. Richards and P.W. Mielke, Jr. 2006. Rank score and permutation testing alternatives for regression quantile estimates. \emph{Journal of Statistical Computation and Simulation} \bold{76}, 331--355

Mielke, P.W., Jr. and K.J. Berry. 2001. \emph{Permutation methods: A distance function approach}. Springer-Verlag. 352pp.}

\keyword{ package }


