# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @importFrom Rcpp sourceCpp
#' @useDynLib BoltzMM
NULL

#'Probability mass function of a fully-visible Boltzmann machine evaluated for an individual vector.
#'@description Compute the probability of a string of n>1 binary spin variables (i.e. each element is -1 or 1) arising from a fully-visible Boltzmann machine with some specified bias vector and interaction matrix.
#'@param xval Vector of length n containing binary spin variables.
#'@param bvec Vector of length n containing real valued bias parameters.
#'@param Mmat Symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.
#'@return The probability of the random string \code{xval} under a fully-visible Boltzmann machine with bias vector \code{bvec} and interaction matrix \code{Mmat}.
#'@references H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
#'@author Andrew T. Jones and Hien D. Nguyen
#'@examples # Compute the probability of the vector xval=(-1,1,-1), under bvec and Mmat.
#'xval <- c(-1,1,-1)
#'bvec <- c(0,0.5,0.25)
#'Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
#'pfvbm(xval,bvec,Mmat)
#'@export
pfvbm <- function(xval, bvec, Mmat) {
    .Call('_BoltzMM_pfvbm', PACKAGE = 'BoltzMM', xval, bvec, Mmat)
}

#'Probability mass function of a fully-visible Boltzmann machine evaluated for all possible vectors.
#'@description Compute the probability of all 2^n strings of n>1 binary spin variables (i.e. each element is -1 or 1) arising from a fully-visible Boltzmann machine with some specified bias vector and interaction matrix.
#'@param bvec Vector of length n containing real valued bias parameters.
#'@param Mmat Symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.
#'@return A vector of the probabilities of all 2^n binary spin vectors under a fully-visible Boltzmann machine with bias vector \code{bvec} and interaction matrix \code{Mmat}. Probabilities are reported in ascending order of the binary strings; i.e for n=2 the reporting order is (-1,1), (-1,1), (1,-1), and (1,1).
#'@references H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
#'@author Andrew T. Jones and Hien D. Nguyen
#'@examples # Compute the probability of every length n=3 binary spin vector under bvec and Mmat.
#'bvec <- c(0,0.5,0.25)
#'Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
#'allpfvbm(bvec,Mmat)
#'@export
allpfvbm <- function(bvec, Mmat) {
    .Call('_BoltzMM_allpfvbm', PACKAGE = 'BoltzMM', bvec, Mmat)
}

#'Random data generation from a fully-visible Boltzmann machine.
#'@description Generate N random strings of n>1 binary spin variables (i.e. each element is -1 or 1) arising from a fully-visible Boltzmann machine with some specified bias vector and interaction matrix.
#'@param num Number N of random strings to be generated.
#'@param bvec Vector of length n containing real valued bias parameters.
#'@param Mmat Symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.
#'@return An N by n matrix, where each row contains a random spin variable string from a fully-visible Boltzmann machine with bias vector \code{bvec} and interaction matrix \code{Mmat}.
#'@note The function \code{allpfvbm} must be called each time this function is run. Thus, it is much more efficient to generate N strings all at once, than to generate strings one at a time.
#'@references H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
#'@author Andrew T. Jones and Hien D. Nguyen
#'@examples # Generate num=10 random strings of n=3 binary spin variables under bvec and Mmat.
#'num <- 10
#'bvec <- c(0,0.5,0.25)
#'Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
#'rfvbm(num,bvec,Mmat)
#'@export
rfvbm <- function(num, bvec, Mmat) {
    .Call('_BoltzMM_rfvbm', PACKAGE = 'BoltzMM', num, bvec, Mmat)
}

#'Maximum pseudolikelihood estimation of a fully-visible Boltzmann machine.
#'@description Estimates the bias vector and interaction matrix of a fully-visible Boltzmann machine via maximum pseudolikelihood estimation using an MM algorithm.
#'@param data An N by n matrix, where each of the N rows contains a length n string of spin variables  (i.e. each element is -1 or 1).
#'@param bvec Initial estimate for a vector of length n containing real valued bias parameters.
#'@param Mmat Initial estimate for a symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.
#'@param delta_crit Real threshold value for the convergence criterion, based on the relative change in the Euclidean distance of parameter estimates from consecutive iterations.
#'@param max_it Integer value indicating the maximum number of iterations that the algorithm is to run for.
#'@return A list containing 4 objects: the final log-pseudolikelihood value \code{pll}, a vector containing the estimate of the bias parameters \code{bvec}, a matrix containing the estimate of the interaction parameters \code{Mmat}, and the number of algorithm iterations \code{itt}.
#'@references H.D. Nguyen and I.A. Wood (2016), A block successive lower-bound maximization algorithm for the maximum pseudolikelihood estimation of fully visible Boltzmann machines, Neural Computation, vol 28, pp. 485-492
#'@author Andrew T. Jones and Hien D. Nguyen
#'@examples # Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
#'num <- 1000
#'bvec <- c(0,0.5,0.25)
#'Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
#'data <- rfvbm(num,bvec,Mmat)
#'# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
#'fitfvbm(data,bvec,Mmat)
#'@export
fitfvbm <- function(data, bvec, Mmat, delta_crit = 0.001, max_it = 1000L) {
    .Call('_BoltzMM_fitfvbm', PACKAGE = 'BoltzMM', data, bvec, Mmat, delta_crit, max_it)
}

#'Partial derivatives of the log-pseudolikelihood function for a fitted fully-visible Boltzmann machine.
#'@description Computes the partial derivatives for all unique parameter elements of the bias vector and interaction matrix of a fully-visible Boltzmann machine, for some random length n string of spin variables (i.e. each element is -1 or 1) and some fitted parameter values.
#'@param data Vector of length n containing binary spin variables.
#'@param model List generated from \code{fitfvbm}.
#'@return A list containing 2 objects: a vector containing the partial derivatives corresponding to the bias parameters \code{bvec}, and a matrix containing the partial derivatives corresponding to the interaction parameters \code{Mmat}.
#'@references H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
#'@author Andrew T. Jones and Hien D. Nguyen
#'@examples # Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
#'num <- 1000
#'bvec <- c(0,0.5,0.25)
#'Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
#'data <- rfvbm(num,bvec,Mmat)
#'# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
#'model <- fitfvbm(data,bvec,Mmat)
#'# Compute the partial derivatives evaluated at the first observation of data.
#'fvbmpartiald(data,model)
#'@export
fvbmpartiald <- function(data, model) {
    .Call('_BoltzMM_fvbmpartiald', PACKAGE = 'BoltzMM', data, model)
}

#'Sandwich estimator of the covariance matrix for a fitted fully-visible Boltzmann machine.
#'@description Computes the sandwich estimator of the covariance matrix for a maximum pseudolikelihood estimated fully-visible Boltzmann machine.
#'@param data An N by n matrix, where each of the N rows contains a length n string of spin variables  (i.e. each element is -1 or 1).
#'@param model List generated from \code{fitfvbm}.
#'@param fvbmHess A function that computes the Hessian of the parameter elements. Currently, the only implemented method is the default \code{fvbmHess} function.
#'@return The n+choose(n,2) by n+choose(n,2) sandwich covariance matrix, estimated using \code{data} and evaluated at the fitted parameter values provided in \code{model}. Each row (column) is a unique element of the bias vector and interaction matrix. The rows are arranged in lexicographical order with the bias elements first, followed by the interaction elements. For example, if n=3, the order would be bias[1], bias[2] bias[3], interaction[1,2], interaction[1,3], and interaction[2,3].
#'@references H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
#'@author Andrew T. Jones and Hien D. Nguyen
#'@examples # Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
#'num <- 1000
#'bvec <- c(0,0.5,0.25)
#'Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
#'data <- rfvbm(num,bvec,Mmat)
#'# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
#'model <- fitfvbm(data,bvec,Mmat)
#'# Compute the sandwich covariance matrix using the data and the model.
#'fvbmcov(data,model,fvbmHess)
#'@export
fvbmcov <- function(data, model, fvbmHess) {
    .Call('_BoltzMM_fvbmcov', PACKAGE = 'BoltzMM', data, model, fvbmHess)
}

