/*
  Copyright (C) 2005 Steven L. Scott

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/

#include <LinAlg/LinAlgExceptions.hpp>
#include <string>
#include <sstream>

namespace BOOM{
  using namespace std;
  using std::string;
  matrix_not_positive_definite::matrix_not_positive_definite
  (const Mat &M, const string &err_msg)
      : m(M), msg(err_msg)
  {}

  string print_matrix_limits(const Mat &m, const string &name=""){
    ostringstream out;
    out << name << "[" << m.nrow() << ","
        << m.ncol() << "] = " << endl
        << m << endl;
    return out.str();
  }

  const char * matrix_not_positive_definite::what()const throw(){
    ostringstream out;
    out << msg << endl;
    out << print_matrix_limits(m);
    return out.str().c_str();
  }

}
