% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CasinoTest.R
\name{CasinoTest}
\alias{CasinoTest}
\title{Multi-group GPC (EXPERIMENTAL)}
\usage{
CasinoTest(
  formula,
  data,
  type = "unweighted",
  add.halfNeutral = NULL,
  method.inference = "u-statistic",
  conf.level = NULL,
  transformation = NULL,
  alternative = NULL,
  method.multcomp = "none",
  seed = NA
)
}
\arguments{
\item{formula}{[formula] a symbolic description of the GPC model, see the \code{BuyseTest} function}

\item{data}{[data.frame] dataset.}

\item{type}{[character] Type of estimator: can be \code{"unweighted"} or \code{"weighted"}.}

\item{add.halfNeutral}{[logical] should half of the neutral score be added to the favorable and unfavorable scores?}

\item{method.inference}{[character] method used to compute confidence intervals and p-values.
Can be \code{"none"}, \code{"u-statistic"}, or \code{"rank"}.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{transformation}{[logical]  should the CI be computed on the inverse hyperbolic tangent scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}. Not relevant when using permutations or percentile bootstrap.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.
Default value read from \code{BuyseTest.options()}.}

\item{method.multcomp}{[character] method used to adjust for multiple comparisons.
Can be any element of ‘p.adjust.methods’ (e.g. "holm"), "maxT-integration", or "maxT-simulation".}

\item{seed}{[integer, >0] Random number generator (RNG) state used when adjusting for multiple comparisons.
If \code{NULL} no state is set.}
}
\value{
An S3 object of class \code{CasinoTest} that inherits from data.frame.
}
\description{
Perform Generalized Pairwise Comparisons (GPC) for two or more groups.
Can handle one or several binary, continuous and time-to-event endpoints.
}
\details{
Require to have installed the package riskRegression and BuyseTest

Setting argument \code{method.inference} to \code{"rank"} uses a U-statistic approach with a small sample correction to match the variance estimator derived in Result 4.16 page 228 of Brunner (2018).
}
\examples{
library(data.table)
library(BuyseTest)

#### simulate data ####
set.seed(11)
n <- 4
dt <- rbind(data.table(score = rnorm(n), group = "A"),
            data.table(score = rnorm(2*n), group = "B"),
            data.table(score = rnorm(3*n), group = "C"))
dt$index <- 1:NROW(dt)

#### estimation ####
score.casino <- dt$score

## naive casino (by hand)
M.score <- outer(dt[group=="A",score],score.casino,function(x,y){x>y+0.5*(x==y)})
mean(M.score)

## naive casino (via BuyseTest)
CasinoTest(group ~ cont(score), data = dt, type = "weighted")

## harmonic casino (by hand)
hweight <- unlist(tapply(dt$group, dt$group, function(x){rep(1/length(x),length(x))}))
M.scoreW <- sweep(M.score, MARGIN = 2, FUN = "*", STATS = NROW(dt)*hweight/3)
mean(M.scoreW)

## harmonic casino (via BuyseTest)
CasinoTest(group ~ cont(score), data = dt, type = "unweighted")

#### Relative liver weights data (Brunner 2018, table 4.1, page 183) ####
liverW <- rbind(
  data.frame(value = c(3.78, 3.40, 3.29, 3.14, 3.55, 3.76, 3.23, 3.31),
             group = "Placebo"),
  data.frame(value = c(3.46,3.98,3.09,3.49,3.31,3.73,3.23),
             group = "Dose 1"),
  data.frame(value = c(3.71, 3.36, 3.38, 3.64, 3.41, 3.29, 3.61, 3.87),
             group = "Dose 2"),
  data.frame(value = c(3.86,3.80,4.14,3.62,3.95,4.12,4.54),
             group = "Dose 3"),
  data.frame(value = c(4.14,4.11,3.89,4.21,4.81,3.91,4.19, 5.05),
             group = "Dose 4")
)
liverW$valueU <- liverW$value + (1:NROW(liverW))/1e6

## same as table 4.1, page 183 in Brunner et al (2018)
CasinoTest(group ~ cont(value), data = liverW, type = "weighted", add.halfNeutral = TRUE)
CasinoTest(group ~ cont(valueU), data = liverW, type = "unweighted", add.halfNeutral = TRUE)
}
\references{
Edgar Brunner, Arne C Bathke, and Frank Konietschke (2018). \bold{Rank and pseudo-rank procedures for independent observations in factorial designs}. Springer.
}
\keyword{models}
