% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simCompetingRisks.R
\name{simCompetingRisks}
\alias{simCompetingRisks}
\title{Simulation of Gompertz competing risks data for the BuyseTest}
\usage{
simCompetingRisks(
  n.T,
  n.C,
  p.1C = NULL,
  v.1C,
  v.1T,
  v.2C,
  v.2T,
  sHR = NULL,
  b.1T = NULL,
  b.1C = NULL,
  b.2T = NULL,
  b.2C = NULL,
  cens.distrib = NULL,
  param.cens = NULL,
  latent = NULL
)
}
\arguments{
\item{n.T}{[integer, >0] number of patients in the treatment arm}

\item{n.C}{[integer, >0] number of patients in the control arm}

\item{p.1C}{[integer, >0] proportion of events of interest in the control group. Can be NULL if and only if \code{(b.1T, b.1C, b.2T, b.2C)}
are provided.}

\item{v.1C, v.1T, v.2C, v.2T}{[double, <0] shape parameters for Gompertz distribution of time to event of interest in control/treatment (C/T) 
group and of time to competing event in control/treatment (C/T) group respectively}

\item{sHR}{[double, >0] pre-specified sub-distribution hazard ratio for event of interest. Can be NULL if and only if 
\code{(b.1T, b.1C, b.2T, b.2C)} are provided.}

\item{b.1C, b.1T, b.2C, b.2T}{[double, >0] rate parameters for Gompertz distribution of time to event of interest in control/treatment (C/T) 
group and of time to competing event in control/treatment (C/T) group respectively. Can be NULL if and only if \code{(p.1C, sHR)} are 
provided.}

\item{cens.distrib}{[character] censoring distribution. Can be \code{"exponential"} for exponential censoring or \code{"uniform"} for
uniform censoring. NULL means no censoring.}

\item{param.cens}{[>0] parameter for censoring distribution. Should be a double for rate parameter of exponential censoring distribution 
or a vector of doubles for lower and upper bounds of uniform censoring distribution. NULL means no censoring}

\item{latent}{[logical] If \code{TRUE}, also export the latent variables (e.g. true event times, true event types and censoring times). 
NULL sets this parameter to \code{FALSE}.}
}
\value{
A data.frame
}
\description{
Simulate Gompertz competing risks data with proportional (via prespecified sub-distribution hazard ratio) or
non-proportional sub-distribution hazards. A treatment variable with two groups (treatment and control) is created.
}
\details{
The times to the event of interest and to the competing event in each group follow an improper Gompertz distribution 
(see Jeong and Fine, 2006), whose cumulative distribution function is 

F(t; b, v) = 1 - exp(b (1 - exp (v t)) / v) \cr 

and hazard functions is

h(t; b, v) = b exp(v t)\cr 

The shape parameters must be negative to have improper distributions for the times to the two events in each group. Note however that 
in each group, the overall cumulative incidence function must be proper (i.e. the maximum values of the cumulative incidence of each 
event type sum up to 1 in each group). When only providing the shape parameters, the rate parameters are
computed to fulfill this condition. In case you whish to provide the rate parameters too, make sure that the condition is met.
}
\examples{

#### Providing p.1C and sHR ####
d <- simCompetingRisks(n.T = 100, n.C = 100, p.1C = 0.55, v.1C = -0.30, 
v.1T = -0.30, v.2C = -0.30, v.2T = -0.30, sHR = 0.5, b.1T = NULL, 
b.1C = NULL, b.2T = NULL, b.2C = NULL)

#### Providing the rate parameters ####
d <- simCompetingRisks(n.T = 100, n.C = 100, p.1C = NULL, v.1C = -0.30, 
v.1T = -0.30, v.2C = -0.30, v.2T = -0.30, sHR = NULL, b.1T = 0.12, 
b.1C = 0.24, b.2T = 0.33, b.2C = 0.18)

#### With exponential censoring ####
d <- simCompetingRisks(n.T = 100, n.C = 100, p.1C = 0.55, v.1C = -0.30, 
v.1T = -0.30, v.2C = -0.30, v.2T = -0.30, sHR = 0.5, b.1T = NULL, 
b.1C = NULL, b.2T = NULL, b.2C = NULL, cens.distrib = "exponential", 
param.cens = 0.8, latent = TRUE)

### With uniform censoring ####
d <- simCompetingRisks(n.T = 100, n.C = 100, p.1C = 0.55, v.1C = -0.30, 
v.1T = -0.30, v.2C = -0.30, v.2T = -0.30, sHR = 0.5, b.1T = NULL, 
b.1C = NULL, b.2T = NULL, b.2C = NULL, cens.distrib = "uniform", 
param.cens = c(0, 7), latent=TRUE)        

}
\references{
Jeong J-H. and Fine J. (2006) \bold{Direct parametric inference for the cumulative incidence function}. \emph{Journal of the Royal Statistical
Society} 55: 187-200 \cr
}
\author{
Eva Cantagallo
}
\keyword{datagen}
