% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C5.0.R
\name{C5.0Control}
\alias{C5.0Control}
\title{Control for C5.0 Models}
\usage{
C5.0Control(subset = TRUE, bands = 0, winnow = FALSE,
  noGlobalPruning = FALSE, CF = 0.25, minCases = 2,
  fuzzyThreshold = FALSE, sample = 0, seed = sample.int(4096, size = 1) -
  1L, earlyStopping = TRUE, label = "outcome")
}
\arguments{
\item{subset}{A logical: should the model evaluate groups of
discrete predictors for splits? Note: the C5.0 command line
version defaults this parameter to \code{FALSE}, meaning no
attempted groupings will be evaluated during the tree growing
stage.}

\item{bands}{An integer between 2 and 1000. If \code{TRUE}, the
model orders the rules by their affect on the error rate and
groups the rules into the specified number of bands. This
modifies the output so that the effect on the error rate can be
seen for the groups of rules within a band. If this options is
selected and \code{rules = FALSE}, a warning is issued and
\code{rules} is changed to \code{TRUE}.}

\item{winnow}{A logical: should predictor winnowing (i.e
feature selection) be used?}

\item{noGlobalPruning}{A logical to toggle whether the final,
global pruning step to simplify the tree.}

\item{CF}{A number in (0, 1) for the confidence factor.}

\item{minCases}{an integer for the smallest number of samples
that must be put in at least two of the splits.}

\item{fuzzyThreshold}{A logical toggle to evaluate possible
advanced splits of the data. See Quinlan (1993) for details and
examples.}

\item{sample}{A value between (0, .999) that specifies the
random proportion of the data should be used to train the model.
By default, all the samples are used for model training. Samples
not used for training are used to evaluate the accuracy of the
model in the printed output.}

\item{seed}{An integer for the random number seed within the C
code.}

\item{earlyStopping}{A logical to toggle whether the internal
method for stopping boosting should be used.}

\item{label}{A character label for the outcome used in the
output. @return A list of options.}
}
\description{
Various parameters that control aspects of the C5.0 fit.
}
\examples{

data(churn)

treeModel <- C5.0(x = churnTrain[, -20], 
                  y = churnTrain$churn,
                  control = C5.0Control(winnow = TRUE))
summary(treeModel)

}
\references{
Quinlan R (1993). C4.5: Programs for Machine
Learning. Morgan Kaufmann Publishers,
\url{http://www.rulequest.com/see5-unix.html}
}
\seealso{
\code{\link[=C5.0]{C5.0()}},\code{\link[=predict.C5.0]{predict.C5.0()}},
\code{\link[=summary.C5.0]{summary.C5.0()}}, \code{\link[=C5imp]{C5imp()}}
}
\author{
Original GPL C code by Ross Quinlan, R code and
modifications to C by Max Kuhn, Steve Weston and Nathan Coulter
}
\keyword{models}
