/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class CorrelationAnalysis
extends DataPlotDialog {
    private JPanel analysisOptionsPane;
    private JCheckBox browserResults;
    private JList colList2;
    private JCheckBox confIntervals;
    private JLabel confLabel;
    private JSpinner confLevel;
    private JRadioButton kendallRadioButton;
    private ButtonGroup methodGroup;
    private JPanel methodPane;
    private JRadioButton pearsonRadioButton;
    private JPanel plotPane;
    private JPanel savePanel;
    private JCheckBox scatterPlot;
    private JRadioButton spearmanRadioButton;
    private JPanel varPane;
    private JScrollPane varScrollPane;

    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CorrelationAnalysis.this.datasetChangedAction();
            }
        });
        this.datasetChangedAction();
        this.confLevel.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));
        this.updateValidity();
    }

    private void refreshVariableLists() {
        String dataset = this.getDatasetPane().getSelectedDataset();
        if (dataset != null) {
            this.colList2.setListData(RUtils.nonFactors(dataset));
        }
    }

    public static Object[] getSelectedItems(JList list) {
        if (list != null) {
            return list.getSelectedValues();
        }
        return null;
    }

    public Object[] getVariables() {
        return CorrelationAnalysis.getSelectedItems(this.colList2);
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.varPane = new JPanel();
        this.varScrollPane = new JScrollPane();
        this.colList2 = new JList();
        this.analysisOptionsPane = new JPanel();
        this.scatterPlot = new JCheckBox();
        this.confIntervals = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevel = new JSpinner();
        this.methodPane = new JPanel();
        this.pearsonRadioButton = new JRadioButton();
        this.kendallRadioButton = new JRadioButton();
        this.spearmanRadioButton = new JRadioButton();
        this.savePanel = new JPanel();
        this.browserResults = new JCheckBox();
        this.methodGroup = new ButtonGroup();
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.varScrollPane.setPreferredSize(new Dimension(100, 140));
        this.varScrollPane.setViewportView(this.colList2);
        GroupLayout varPaneLayout = new GroupLayout((Container)this.varPane);
        this.varPane.setLayout((LayoutManager)varPaneLayout);
        varPaneLayout.setHorizontalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.varScrollPane, -1, 154, Short.MAX_VALUE).addContainerGap()));
        varPaneLayout.setVerticalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add(2, (GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.varScrollPane, -1, 233, Short.MAX_VALUE).addContainerGap()));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.scatterPlot.setText("Create Scatterplot Matrix");
        this.confIntervals.setText("Compute Confidence Intervals");
        this.confIntervals.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CorrelationAnalysis.this.confIntervalsStateChanged(evt);
            }
        });
        this.confLabel.setText("Confidence Level:");
        GroupLayout analysisOptionsPaneLayout = new GroupLayout((Container)this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout((LayoutManager)analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.scatterPlot)).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1, false).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.confLabel).addPreferredGap(0).add((Component)this.confLevel)).add((Component)this.confIntervals)))).addContainerGap(42, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.scatterPlot).addPreferredGap(0).add((Component)this.confIntervals).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.confLabel).add((Component)this.confLevel, -2, -1, -2)).addContainerGap()));
        this.methodPane.setBorder(BorderFactory.createTitledBorder("Method"));
        this.methodGroup.add(this.pearsonRadioButton);
        this.pearsonRadioButton.setSelected(true);
        this.pearsonRadioButton.setText("Pearson");
        this.methodGroup.add(this.kendallRadioButton);
        this.kendallRadioButton.setText("Kendall");
        this.methodGroup.add(this.spearmanRadioButton);
        this.spearmanRadioButton.setText("Spearman");
        GroupLayout methodPaneLayout = new GroupLayout((Container)this.methodPane);
        this.methodPane.setLayout((LayoutManager)methodPaneLayout);
        methodPaneLayout.setHorizontalGroup((GroupLayout.Group)methodPaneLayout.createParallelGroup(1).add((GroupLayout.Group)methodPaneLayout.createSequentialGroup().add((GroupLayout.Group)methodPaneLayout.createParallelGroup(1).add((GroupLayout.Group)methodPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.pearsonRadioButton)).add((GroupLayout.Group)methodPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.kendallRadioButton)).add((GroupLayout.Group)methodPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.spearmanRadioButton))).addContainerGap(140, Short.MAX_VALUE)));
        methodPaneLayout.setVerticalGroup((GroupLayout.Group)methodPaneLayout.createParallelGroup(1).add((GroupLayout.Group)methodPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.pearsonRadioButton).addPreferredGap(0).add((Component)this.kendallRadioButton).addPreferredGap(0).add((Component)this.spearmanRadioButton).addContainerGap()));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.browserResults.setText("Display Results in Browser");
        this.browserResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserResults.setMargin(new Insets(0, 0, 0, 0));
        this.browserResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CorrelationAnalysis.this.browserResultsActionPerformed(evt);
            }
        });
        GroupLayout savePanelLayout = new GroupLayout((Container)this.savePanel);
        this.savePanel.setLayout((LayoutManager)savePanelLayout);
        savePanelLayout.setHorizontalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.browserResults).addContainerGap(66, Short.MAX_VALUE)));
        savePanelLayout.setVerticalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().add((Component)this.browserResults).addContainerGap(5, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.varPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((Component)this.methodPane, -1, -1, Short.MAX_VALUE).add((Component)this.analysisOptionsPane, -1, -1, Short.MAX_VALUE).add((Component)this.savePanel, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.linkSize(new Component[]{this.analysisOptionsPane, this.methodPane}, 1);
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.varPane, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.methodPane, -2, -1, -2).addPreferredGap(0).add((Component)this.analysisOptionsPane, -2, -1, -2).addPreferredGap(0).add((Component)this.savePanel, -2, 47, -2))).addContainerGap()));
        this.setTitle("Correlation Analysis");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 480) / 2, (screenSize.height - 453) / 2, 480, 453);
    }

    private void confIntervalsStateChanged(ChangeEvent evt) {
        this.updateValidity();
    }

    private void browserResultsActionPerformed(ActionEvent evt) {
    }

    private void updateValidity() {
        boolean enableConfLevel = this.confIntervals.isSelected();
        this.confLabel.setEnabled(enableConfLevel);
        this.confLevel.setEnabled(enableConfLevel);
    }

    private List getColumn(JTable table, int column) {
        if (table != null && column <= table.getColumnCount()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                list.add(table.getValueAt(i, column));
            }
            return list;
        }
        return null;
    }

    protected void submitButtonAction() {
        String method = null;
        if (this.pearsonRadioButton.isSelected()) {
            method = "pearson";
        } else if (this.kendallRadioButton.isSelected()) {
            method = "kendall";
        } else if (this.spearmanRadioButton.isSelected()) {
            method = "spearman";
        }
        String cmd = "cor.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", my.vars=" + "c(" + RUtils.toString(this.getVariables(), ",", "'") + ")" + ", iMethod=" + "'" + method + "'" + ", iCI=" + String.valueOf(this.confIntervals.isSelected()).toUpperCase() + (this.confIntervals.isSelected() ? ", conf.level=" + (Double)this.confLevel.getValue() : "") + ", iScatterplot=" + String.valueOf(this.scatterPlot.isSelected()).toUpperCase() + ", browserResults=" + String.valueOf(this.browserResults.isSelected()).toUpperCase() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void helpButtonAction() {
        String cmd = "CADStat.help('cor.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void datasetChangedAction() {
        this.refreshVariableLists();
    }
}

