% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_plot.r
\name{CoUMAP}
\alias{CoUMAP}
\title{Co-embedding UMAP for Genes and Cells in a Seurat Object}
\usage{
CoUMAP(
  seu,
  reduction = "caesar",
  reduction.name = "caesarUMAP",
  gene.set = NULL,
  slot = "data",
  assay = "RNA",
  seed = 1,
  ...
)
}
\arguments{
\item{seu}{A Seurat object containing the single-cell RNA-seq data.}

\item{reduction}{A character string specifying the name of the dimensional reduction to use (e.g., "caesar"). Default is "caesar".}

\item{reduction.name}{A character string specifying the name of the new dimensional reduction slot in the Seurat object where the co-embedding UMAP will be stored. Default is "caesarUMAP".}

\item{gene.set}{A character vector specifying the set of genes to include in the co-embedding. If \code{NULL}, all genes are used. Default is \code{NULL}.}

\item{slot}{A character string specifying the slot in the Seurat object to use for gene expression data. Default is "data".}

\item{assay}{A character string specifying the assay to use. Default is "RNA".}

\item{seed}{An integer specifying the random seed for reproducibility. Default is 1.}

\item{...}{Additional arguments passed to \code{scater::calculateUMAP}.}
}
\value{
A modified Seurat object with the co-embedding UMAP stored in the specified \code{reduction.name} slot.
}
\description{
This function performs a co-embedding UMAP of both gene and cell embeddings from a Seurat object. It integrates the dimensionality reduction results for genes and cells into a shared UMAP space.
}
\details{
The function extracts the embeddings for both genes and cells from the specified dimensional reduction, combines them, and computes a UMAP embedding. The resulting co-embedding UMAP is stored in a new dimensional reduction slot in the Seurat object.
}
\examples{
data(toydata)

seu <- toydata$seu

seu <- CoUMAP(seu, gene.set = rownames(seu))
print(seu)
}
\seealso{
\code{\link[scater]{calculateUMAP}} for UMAP calculation.
}
